/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.widget.LoadingCircle;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.render.RenderHelper;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;

public abstract class BaseScreen
extends Screen {
    private static final ResourceLocation GENERIC = new ResourceLocation(SkyGUIs.getInstance().modid, "textures/gui/generic.png");
    protected static final MutableComponent PREV_SCREEN_COMPONENT = ComponentBuilder.text("previous_screen", new Object[0]);
    public static final OnAbort DEFAULT_ABORT = () -> ForgeHooksClient.popGuiLayer((Minecraft)Minecraft.m_91087_());
    protected final int xSize;
    protected final int ySize;
    protected int relX;
    protected int relY;
    protected boolean preventUserInput;
    private LoadingResult loadingResult;
    @Nullable
    private LoadingCircle loadingCircle;

    public BaseScreen(Component component, int xSize, int ySize) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
        MinecraftForge.EVENT_BUS.addListener(this::guiInitPre);
        MinecraftForge.EVENT_BUS.addListener(this::guiInitPost);
    }

    private void guiInitPre(ScreenEvent.InitScreenEvent.Pre event) {
        this.relX = (event.getScreen().f_96543_ - this.xSize) / 2;
        this.relY = (event.getScreen().f_96544_ - this.ySize) / 2;
    }

    private void guiInitPost(ScreenEvent.InitScreenEvent.Post event) {
        boolean prevActive = this.loadingCircle != null && this.loadingCircle.isActive();
        this.loadingCircle = this.createLoadingCircle();
        if (this.loadingCircle != null) {
            this.loadingCircle.setActive(prevActive);
        }
    }

    public final void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean loadingCircleActive;
        boolean bl = loadingCircleActive = this.loadingCircle != null && this.loadingCircle.isActive();
        if (!loadingCircleActive) {
            this.m_7333_(poseStack);
        }
        this.render_(poseStack, mouseX, mouseY, partialTick);
        if (loadingCircleActive) {
            this.m_7333_(poseStack);
            this.loadingCircle.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderHelper.renderGuiBackground((PoseStack)poseStack, (int)this.relX, (int)this.relY, (int)this.xSize, (int)this.ySize, (ResourceLocation)GENERIC, (int)128, (int)64, (int)4, (int)125, (int)4, (int)60);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Nullable
    public LoadingCircle createLoadingCircle() {
        return null;
    }

    @Nullable
    public LoadingCircle getLoadingCircle() {
        return this.loadingCircle;
    }

    public void onLoadingResult(LoadingResult result) {
    }

    public void renderTitle(@Nonnull PoseStack poseStack) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.centeredX(this.f_96547_.m_92724_(this.f_96539_.m_7532_())), (float)this.y(10), Color.DARK_GRAY.getRGB());
    }

    public float centeredX(float width) {
        return this.x((float)this.xSize / 2.0f - width);
    }

    public float centeredY(float height) {
        return this.x((float)this.xSize / 2.0f - height);
    }

    public int centeredX(int width) {
        return (int)this.x((float)this.xSize / 2.0f - (float)width / 2.0f);
    }

    public int centeredY(int height) {
        return (int)this.y((float)this.ySize / 2.0f - (float)height / 2.0f);
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public int getRelX() {
        return this.relX;
    }

    public int getRelY() {
        return this.relY;
    }

    public int x(int x) {
        return this.relX + x;
    }

    public int y(int y) {
        return this.relY + y;
    }

    public float x(float x) {
        return (float)this.relX + x;
    }

    public float y(float y) {
        return (float)this.relY + y;
    }

    public void m_96624_() {
        if (this.loadingCircle != null && this.loadingCircle.isActive()) {
            this.preventUserInput = true;
            LoadingResult result = this.getResult();
            if (result != null) {
                this.onLoadingResult(result);
                this.loadingCircle.setActive(false);
                this.preventUserInput = false;
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.preventUserInput) {
            return false;
        }
        InputConstants.Key mapping = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mapping) && !(this.m_7222_() instanceof EditBox)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_5755_(boolean focus) {
        if (this.preventUserInput) {
            return false;
        }
        return super.m_5755_(focus);
    }

    public boolean m_7043_() {
        return false;
    }

    protected LoadingResult getResult() {
        LoadingResult tempResult = null;
        if (this.loadingResult != null) {
            tempResult = this.loadingResult;
            this.loadingResult = null;
        }
        return tempResult;
    }

    public void setResult(@Nonnull LoadingResult result) {
        this.loadingResult = result;
    }

    public static interface OnAbort {
        public void onAbort();
    }

    public static interface OnConfirm {
        public void onConfirm();
    }
}

