/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.base.list.PlayerListScreen;
import de.melanx.skyguis.client.screen.info.AllTeamsScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.client.widget.sizable.SizeableCheckbox;
import de.melanx.skyguis.util.ComponentBuilder;
import java.awt.Color;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.ForgeHooksClient;

public class TeamPlayersScreen
extends PlayerListScreen {
    private final Team team;
    private final BaseScreen prev;
    private Button kickButton;
    private Checkbox selectAll;
    private int selectedAmount = 0;

    public TeamPlayersScreen(Team team, BaseScreen prev) {
        super((Component)new TextComponent(team.getName()), team.getPlayers(), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
        this.team = team;
        this.prev = prev;
    }

    @Override
    protected void m_7856_() {
        this.kickButton = (Button)this.m_142416_((GuiEventListener)new Button(this.x(10), this.y(200), 40, 20, (Component)ComponentBuilder.text("kick", new Object[0]), button -> {
            Set removalIds = this.getSelectedValues().stream().map(GameProfile::getId).collect(Collectors.toSet());
            ForgeHooksClient.pushGuiLayer((Minecraft)Minecraft.m_91087_(), (Screen)new YouSureScreen((Component)ComponentBuilder.text("you_sure_kick", new Object[0]), () -> {
                SkyGUIs.getNetwork().handleKickPlayers(this.team.getName(), removalIds);
                if (removalIds.contains(Minecraft.m_91087_().f_91074_.m_36316_().getId())) {
                    Minecraft.m_91087_().m_91152_((Screen)new AllTeamsScreen());
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)new TeamPlayersScreen(this.team, this.prev));
                }
            }, () -> Minecraft.m_91087_().m_91152_((Screen)this)));
        }));
        this.m_142416_((GuiEventListener)new Button(this.x(57), this.y(200), 115, 20, (Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)));
        this.selectAll = (Checkbox)this.m_142416_((GuiEventListener)new SizeableCheckbox(this.x(9), this.y(32), 14, false, (checkbox, poseStack, mouseX, mouseY) -> this.m_96602_(poseStack, this.allSelected() ? UNSELECT_ALL : SELECT_ALL, mouseX, mouseY)){

            public void m_5691_() {
                super.m_5691_();
                if (this.f_93822_) {
                    TeamPlayersScreen.this.selectAll();
                } else {
                    TeamPlayersScreen.this.unselectAll();
                }
            }
        });
        super.m_7856_();
        this.updateButtons();
    }

    @Override
    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render_(poseStack, mouseX, mouseY, partialTick);
        this.f_96547_.m_92889_(poseStack, (Component)ComponentBuilder.text("selected_amount", this.selectedAmount), (float)this.x(28), (float)this.y(35), Color.DARK_GRAY.getRGB());
    }

    public void updateButtons() {
        Set selectedIds = this.getSelectedValues().stream().map(GameProfile::getId).collect(Collectors.toSet());
        this.kickButton.f_93623_ = selectedIds.size() > 0;
        this.selectAll.f_93822_ = this.allSelected();
        this.selectedAmount = selectedIds.size();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean ret = super.m_6375_(mouseX, mouseY, button);
        this.updateButtons();
        return ret;
    }

    @Override
    protected int entriesPerPage() {
        return 10;
    }
}

