/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.CreateTeamScreen;
import de.melanx.skyguis.client.screen.info.TeamEditScreen;
import de.melanx.skyguis.client.screen.info.TeamInfoScreen;
import de.melanx.skyguis.client.widget.ClickableText;
import de.melanx.skyguis.client.widget.ScrollbarWidget;
import de.melanx.skyguis.config.ClientConfig;
import de.melanx.skyguis.tooltip.SmallTextTooltip;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import io.github.noeppi_noeppi.libx.util.Math2;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AllTeamsScreen
extends BaseScreen {
    public static final int ENTRIES = 13;
    private static final Component TEAMS_COMPONENT = ComponentBuilder.text("teams", new Object[0]).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private static final Component MEMBERS_COMPONENT = ComponentBuilder.text("members", new Object[0]).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private static final Component YOUR_TEAM = ComponentBuilder.text("your_team", new Object[0]);
    private final List<Team> teams;
    private final Team playerTeam;
    private ScrollbarWidget scrollbar;
    private Button yourTeamButton;

    public AllTeamsScreen() {
        super(TEAMS_COMPONENT, 200, 230);
        this.teams = SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_).getTeams().stream().filter(team -> !team.getName().isEmpty()).filter(team -> !team.isSpawn()).sorted(Comparator.comparing(team -> team.getName().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        this.playerTeam = SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_).getTeamFromPlayer((Player)Minecraft.m_91087_().f_91074_);
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new AllTeamsScreen());
    }

    protected void m_7856_() {
        if (this.playerTeam == null) {
            this.m_142416_((GuiEventListener)new Button(this.x(10), this.y(199), 160, 20, (Component)ComponentBuilder.title("create_team", new Object[0]), button -> Minecraft.m_91087_().m_91152_((Screen)new CreateTeamScreen())));
            this.yourTeamButton = null;
        } else {
            TextComponent component = new TextComponent(this.playerTeam.getName());
            this.yourTeamButton = (Button)this.m_142416_((GuiEventListener)new ClickableText(this.x(15) + TextHelper.stringLength((FormattedText)YOUR_TEAM), this.y(207), TextHelper.DARK_GREEN.getRGB(), (Component)component, button -> Minecraft.m_91087_().m_91152_((Screen)new TeamEditScreen(this.playerTeam, this))));
        }
        this.scrollbar = new ScrollbarWidget(this, this.xSize - 20, 33, 12, this.ySize - 45);
        this.updateScrollbar();
    }

    @Override
    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render_(poseStack, mouseX, mouseY, partialTick);
        this.scrollbar.render(poseStack);
        this.f_96547_.m_92889_(poseStack, TEAMS_COMPONENT, (float)this.x(10), (float)this.y(13), Color.DARK_GRAY.getRGB());
        int memberLength = this.f_96547_.m_92724_(MEMBERS_COMPONENT.m_7532_());
        this.f_96547_.m_92889_(poseStack, MEMBERS_COMPONENT, (float)(this.x(179) - memberLength), (float)this.y(13), Color.DARK_GRAY.getRGB());
        if (this.playerTeam != null) {
            this.m_93154_(poseStack, this.x(8), this.x(this.xSize - 26), this.y(197), Color.GRAY.getRGB());
            this.f_96547_.m_92889_(poseStack, YOUR_TEAM, (float)this.x(10), (float)this.y(207), Color.DARK_GRAY.getRGB());
            if (this.yourTeamButton.f_93622_) {
                this.renderTeamTooltip(poseStack, mouseX, mouseY, this.playerTeam);
            }
        }
        int j = 0;
        for (int i = this.scrollbar.getOffset(); i < this.teams.size() && j < 13; ++j, ++i) {
            Team team = this.teams.get(i);
            String name = team.getName();
            String s = TextHelper.shorten(this.f_96547_, name, 175 - memberLength);
            TextComponent playerSizeComponent = new TextComponent(String.valueOf(team.getPlayers().size()));
            TextComponent teamNameComponent = new TextComponent(s);
            float x = this.x(179.0f - (float)memberLength / 2.0f - (float)this.f_96547_.m_92724_(playerSizeComponent.m_7532_()) / 2.0f);
            int y = this.y(37 + j * 12);
            this.f_96547_.m_92889_(poseStack, (Component)teamNameComponent, (float)this.x(10), (float)y, team.isEmpty() ? TextHelper.LIGHT_RED.getRGB() : TextHelper.DARK_GREEN.getRGB());
            this.f_96547_.m_92889_(poseStack, (Component)playerSizeComponent, x, (float)y, Color.DARK_GRAY.getRGB());
            boolean inBounds = Math2.isInBounds((double)this.x(10), (double)y, (double)this.f_96547_.m_92724_(teamNameComponent.m_7532_()), (double)11.0, (double)mouseX, (double)mouseY);
            if (!inBounds) continue;
            this.renderTeamTooltip(poseStack, mouseX, mouseY, team);
        }
    }

    private void renderTeamTooltip(@Nonnull PoseStack poseStack, int mouseX, int mouseY, @Nonnull Team team) {
        ArrayList textLines = Lists.newArrayList((Object[])new Component[]{new TextComponent(team.getName())});
        ArrayList smallTextLines = Lists.newArrayList();
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92125_) {
            smallTextLines.add(ComponentBuilder.text("team_id", new Object[0]).m_130946_(": " + team.getId().toString()));
        }
        smallTextLines.add(ComponentBuilder.text("members", new Object[0]).m_130946_(": " + team.getPlayers().size()));
        smallTextLines.add(ComponentBuilder.text("created_at", new Object[0]).m_130946_(": " + ClientConfig.date.format(new Date(team.getCreatedAt()))));
        smallTextLines.add(ComponentBuilder.text("last_changed", new Object[0]).m_130946_(": " + ClientConfig.date.format(new Date(team.getLastChanged()))));
        this.m_169388_(poseStack, textLines, Optional.of(new SmallTextTooltip(smallTextLines, Color.GRAY)), mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrollbar.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int entries = Math.min(13, this.teams.size());
        if (Math2.isInBounds((double)10.0, (double)37.0, (double)175.0, (double)(entries * 12), (double)(mouseX -= (double)this.relX), (double)(mouseY -= (double)this.relY))) {
            int index = (int)((mouseY - 37.0) / 12.0) + this.scrollbar.getOffset();
            Team team = this.teams.get(index);
            if (Math2.isInBounds((double)10.0, (double)37.0, (double)this.f_96547_.m_92895_(team.getName()), (double)(entries * 12), (double)mouseX, (double)mouseY)) {
                if (team.hasPlayer((Player)Minecraft.m_91087_().f_91074_)) {
                    Minecraft.m_91087_().m_91152_((Screen)new TeamEditScreen(team, this));
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)new TeamInfoScreen(team, this));
                }
            }
            return true;
        }
        return super.m_6375_(mouseX + (double)this.relX, mouseY + (double)this.relY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.scrollbar.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.scrollbar.m_6348_(mouseX, mouseY, button) || super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollbar.m_6050_(mouseX, mouseY, delta) || super.m_6050_(mouseX, mouseY, delta);
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.teams.size() > 13);
        this.scrollbar.setMaxOffset(this.teams.size() - 13);
    }
}

