/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.widget.LoadingCircle;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeHooksClient;

public class TeamInfoScreen
extends BaseScreen {
    private static final MutableComponent CONFIG_SELF_MANAGEMENT = new TranslatableComponent("skyblockbuilder.command.disabled.join_request").m_130940_(ChatFormatting.RED);
    private static final MutableComponent TEAM_JOIN_REQUESTS = new TranslatableComponent("skyblockbuilder.command.disabled.team_join_request").m_130940_(ChatFormatting.RED);
    private static final MutableComponent CONFIG_ALLOW_VISITS = new TranslatableComponent("skyblockbuilder.command.disabled.team_visit").m_130940_(ChatFormatting.RED);
    private static final MutableComponent TEAM_ALLOW_VISITS = new TranslatableComponent("skyblockbuilder.command.disabled.visit_team").m_130940_(ChatFormatting.RED);
    private static final MutableComponent USER_HAS_TEAM = new TranslatableComponent("skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED);
    private static final MutableComponent VISIT_TEAM = ComponentBuilder.text("visit_team", new Object[0]);
    private static final MutableComponent REQUEST_TO_JOIN = ComponentBuilder.text("request_to_join", new Object[0]);
    private static final MutableComponent REQUESTED_TO_JOIN = ComponentBuilder.text("requested_to_join", new Object[0]).m_130940_(ChatFormatting.GREEN);
    private final Team team;
    private final BaseScreen prev;

    public TeamInfoScreen(Team team, BaseScreen prev) {
        super((Component)new TextComponent(team.getName()), 245, 85);
        this.team = team;
        this.prev = prev;
    }

    protected void m_7856_() {
        Button joinButton = new Button(this.x(10), this.y(30), 110, 20, (Component)(this.alreadySentJoinRequest() ? REQUESTED_TO_JOIN : REQUEST_TO_JOIN), button -> {}, (button, poseStack, mouseX, mouseY) -> {
            if (SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_).hasPlayerTeam((Player)Minecraft.m_91087_().f_91074_)) {
                this.m_96602_(poseStack, (Component)USER_HAS_TEAM, mouseX, mouseY);
            } else if (!ConfigHandler.Utility.selfManage) {
                this.m_96602_(poseStack, (Component)CONFIG_SELF_MANAGEMENT, mouseX, mouseY);
            } else if (!this.team.allowsJoinRequests()) {
                this.m_96602_(poseStack, (Component)TEAM_JOIN_REQUESTS, mouseX, mouseY);
            }
        });
        joinButton.f_93623_ = ConfigHandler.Utility.selfManage && this.team.allowsJoinRequests() && !this.alreadySentJoinRequest();
        this.m_142416_((GuiEventListener)joinButton);
        Button visitButton = new Button(this.x(125), this.y(30), 110, 20, (Component)VISIT_TEAM, button -> {
            SkyGUIs.getNetwork().handleVisitTeam(this.team.getId());
            this.getLoadingCircle().setActive(true);
        }, (button, poseStack, mouseX, mouseY) -> {
            if (!ConfigHandler.Utility.Teleports.allowVisits) {
                this.m_96602_(poseStack, (Component)CONFIG_ALLOW_VISITS, mouseX, mouseY);
            } else if (!this.team.allowsVisits()) {
                this.m_96602_(poseStack, (Component)TEAM_ALLOW_VISITS, mouseX, mouseY);
            }
        });
        visitButton.f_93623_ = ConfigHandler.Utility.Teleports.allowVisits && this.team.allowsVisits();
        this.m_142416_((GuiEventListener)visitButton);
        this.m_142416_((GuiEventListener)new Button(this.x(10), this.y(55), 226, 20, (Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)));
    }

    @Override
    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.render_(poseStack, mouseX, mouseY, partialTick);
        this.renderTitle(poseStack);
    }

    @Override
    @Nullable
    public LoadingCircle createLoadingCircle() {
        return new LoadingCircle(this.centeredX(32), this.centeredY(32), 32);
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        Minecraft minecraft = Minecraft.m_91087_();
        switch (result.status()) {
            case SUCCESS: {
                minecraft.f_91080_ = null;
                minecraft.f_91074_.m_6352_(result.reason(), Util.f_137441_);
                break;
            }
            case FAIL: {
                ForgeHooksClient.pushGuiLayer((Minecraft)minecraft, (Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ForgeHooksClient.popGuiLayer((Minecraft)minecraft)));
            }
        }
    }

    private boolean alreadySentJoinRequest() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && this.team.getJoinRequests().contains(player.m_142081_());
    }
}

