/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.widget.ScrollbarWidgetListener;
import io.github.noeppi_noeppi.libx.util.Math2;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;

public class ScrollbarWidget
implements GuiEventListener {
    private static final int SCROLLER_HEIGHT = 15;
    private static final ResourceLocation ICONS = new ResourceLocation(SkyGUIs.getInstance().modid, "textures/gui/icons.png");
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final List<ScrollbarWidgetListener> listeners = new LinkedList<ScrollbarWidgetListener>();
    private final BaseScreen screen;
    private boolean enabled = false;
    private int offset;
    private int maxOffset;
    private boolean clicked = false;

    public ScrollbarWidget(BaseScreen screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void addListener(ScrollbarWidgetListener listener) {
        this.listeners.add(listener);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void render(@Nonnull PoseStack poseStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)(this.screen.getRelX() + this.x - 1), (int)(this.screen.getRelY() + this.y - 1), (int)(this.width + 2), (int)1, (float)0.0f, (float)15.0f, (int)14, (int)1, (int)256, (int)256);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)(this.screen.getRelX() + this.x - 1), (int)(this.screen.getRelY() + this.y), (int)(this.width + 2), (int)this.height, (float)0.0f, (float)17.0f, (int)14, (int)12, (int)256, (int)256);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)(this.screen.getRelX() + this.x - 1), (int)(this.screen.getRelY() + this.y + this.height), (int)(this.width + 2), (int)1, (float)0.0f, (float)31.0f, (int)14, (int)1, (int)256, (int)256);
        this.screen.m_93228_(poseStack, this.screen.getRelX() + this.x, this.screen.getRelY() + this.y + (int)Math.min((float)(this.height - 15), (float)this.offset / (float)this.maxOffset * (float)(this.height - 15)), this.enabled ? 0 : 12, 0, 12, 15);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.clicked && Math2.isInBounds((double)this.x, (double)this.y, (double)this.width, (double)this.height, (double)(mouseX -= (double)this.screen.getRelX()), (double)(mouseY -= (double)this.screen.getRelY()))) {
            this.updateOffset(mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && Math2.isInBounds((double)this.x, (double)this.y, (double)this.width, (double)this.height, (double)(mouseX -= (double)this.screen.getRelX()), (double)(mouseY -= (double)this.screen.getRelY()))) {
            this.updateOffset(mouseY);
            this.clicked = true;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.clicked) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.enabled) {
            this.setOffset(this.offset + Math.max(Math.min(-((int)scrollDelta), 1), -1));
            return true;
        }
        return false;
    }

    public void updateOffset(double offset) {
        this.setOffset((int)Math.floor((float)(offset - (double)this.y) / (float)(this.height - 15) * (float)this.maxOffset));
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        if (this.offset > maxOffset) {
            this.offset = Math.max(0, maxOffset);
        }
    }

    public void setOffset(int offset) {
        int oldOffset = this.offset;
        if (offset >= 0 && offset <= this.maxOffset) {
            this.offset = offset;
            this.listeners.forEach(l -> l.onOffsetChanged(oldOffset, offset));
        }
    }

    public int getOffset() {
        return this.offset;
    }
}

