/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network;

import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyguis.network.handler.AnswerInvitation;
import de.melanx.skyguis.network.handler.CreateTeamScreenClick;
import de.melanx.skyguis.network.handler.EditSpawns;
import de.melanx.skyguis.network.handler.InvitePlayers;
import de.melanx.skyguis.network.handler.OpenGui;
import de.melanx.skyguis.network.handler.RequestTemplateFromServer;
import de.melanx.skyguis.network.handler.SendLoadingResult;
import de.melanx.skyguis.network.handler.SendTemplateToClient;
import de.melanx.skyguis.network.handler.UpdateTeam;
import de.melanx.skyguis.network.handler.VisitTeam;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EasyNetwork
extends NetworkX {
    public EasyNetwork(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"2");
    }

    protected void registerPackets() {
        this.register(new CreateTeamScreenClick.Serializer(), () -> CreateTeamScreenClick::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new UpdateTeam.Serializer(), () -> UpdateTeam::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new EditSpawns.Serializer(), () -> EditSpawns::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new InvitePlayers.Serializer(), () -> InvitePlayers::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new AnswerInvitation.Serializer(), () -> AnswerInvitation::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new RequestTemplateFromServer.Serializer(), () -> RequestTemplateFromServer::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new VisitTeam.Serializer(), () -> VisitTeam::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new OpenGui.Serializer(), () -> OpenGui::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new SendLoadingResult.Serializer(), () -> SendLoadingResult::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new SendTemplateToClient.Serializer(), () -> SendTemplateToClient::handle, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void handleCreateTeam(String name, String shape) {
        this.channel.sendToServer((Object)new CreateTeamScreenClick.Message(name, shape));
    }

    public void handleKickPlayers(String teamName, Set<UUID> players) {
        this.channel.sendToServer((Object)new UpdateTeam.Message(teamName, players));
    }

    public void handleInvitePlayers(String teamName, Set<UUID> players) {
        this.channel.sendToServer((Object)new InvitePlayers.Message(teamName, players));
    }

    public void handleInvitationAnswer(String teamName, AnswerInvitation.Type type) {
        this.channel.sendToServer((Object)new AnswerInvitation.Message(teamName, type));
    }

    public void handleEditSpawns(EditSpawns.Type type, BlockPos pos) {
        this.channel.sendToServer((Object)new EditSpawns.Message(type, pos));
    }

    public void handleLoadingResult(NetworkEvent.Context ctx, LoadingResult.Status result, Component reason) {
        this.channel.reply((Object)new SendLoadingResult.Message(result, reason), ctx);
    }

    public void requestTemplateFromServer(String name) {
        this.channel.sendToServer((Object)new RequestTemplateFromServer.Message(name));
    }

    public void handleVisitTeam(UUID team) {
        this.channel.sendToServer((Object)new VisitTeam.Message(team));
    }

    public void sendTemplateToClient(NetworkEvent.Context ctx, String name) {
        this.channel.reply((Object)new SendTemplateToClient.Message(name, TemplateLoader.getConfiguredTemplate((String)name)), ctx);
    }
}

