/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class AnswerInvitation {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            SkyblockSavedData data = SkyblockSavedData.get((Level)player.m_20193_());
            Team team = data.getTeam(msg.teamName);
            EasyNetwork network = SkyGUIs.getNetwork();
            switch (msg.type) {
                case ACCEPT: {
                    if (team == null) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    if (data.hasPlayerTeam((Player)player)) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    if (!data.hasInvites((Player)player)) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.no_invitations").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    switch (SkyblockHooks.onAccept((ServerPlayer)player, (Team)team)) {
                        case DENY: {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.denied.accept_invitations").m_130940_(ChatFormatting.RED));
                            return;
                        }
                        case DEFAULT: {
                            if (ConfigHandler.Utility.selfManage || player.m_20310_(2)) break;
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.disabled.accept_invitations").m_130940_(ChatFormatting.RED));
                            return;
                        }
                    }
                    if (!data.acceptInvite(team, (Player)player)) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.accept_invitations").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.joined_team").m_130940_(ChatFormatting.GOLD));
                    break;
                }
                case IGNORE: {
                    if (team == null) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    if (!data.hasInvites((Player)player)) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.no_invitations").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    switch (SkyblockHooks.onDecline((ServerPlayer)player, (Team)team)) {
                        case DENY: {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.denied.decline_invitations").m_130940_(ChatFormatting.RED));
                            return;
                        }
                        case DEFAULT: {
                            if (ConfigHandler.Utility.selfManage || player.m_20310_(2)) break;
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.disabled.decline_invitations").m_130940_(ChatFormatting.RED));
                            return;
                        }
                    }
                    if (!data.declineInvite(team, (Player)player)) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.decline_invitations").m_130940_(ChatFormatting.RED));
                        return;
                    }
                    network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.declined_invitation", new Object[]{team.getName()}).m_130940_(ChatFormatting.GOLD));
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public record Message(String teamName, Type type) {
    }

    public static enum Type {
        ACCEPT,
        IGNORE;

    }

    public static class Serializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.teamName);
            buffer.m_130068_((Enum)msg.type);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130277_(), (Type)buffer.m_130066_(Type.class));
        }
    }
}

