/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class CreateTeamScreenClick {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (SkyblockHooks.onCreateTeam((String)msg.name)) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.denied.create_team").m_130940_(ChatFormatting.RED));
                return;
            }
            ServerLevel level = player.m_183503_();
            ConfiguredTemplate template = TemplateLoader.getConfiguredTemplate((String)msg.shape);
            if (template == null) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("shape_does_not_exist", new Object[0]).m_130940_(ChatFormatting.RED));
                return;
            }
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            if (data.hasPlayerTeam((Player)player)) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED));
                return;
            }
            Team team = data.createTeam(msg.name, template);
            if (team == null) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.team_already_exist", new Object[]{msg.name}).m_130940_(ChatFormatting.RED));
                return;
            }
            team.addPlayer((Player)player);
            WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
            network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.create_team", new Object[]{team.getName()}).m_130940_(ChatFormatting.GREEN));
        });
        ctx.setPacketHandled(true);
    }

    public record Message(String name, String shape) {
    }

    public static class Serializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.name);
            buffer.m_130070_(msg.shape);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130277_(), buffer.m_130277_());
        }
    }
}

