/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class EditSpawns {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            ServerLevel level = (ServerLevel)player.m_20193_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED));
                return;
            }
            switch (msg.type) {
                case ADD: {
                    Event.Result result = (Event.Result)SkyblockHooks.onAddSpawn((ServerPlayer)player, (Team)team, (BlockPos)msg.pos).getLeft();
                    switch (result) {
                        case DENY: {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.denied.create_spawn"));
                            return;
                        }
                        case DEFAULT: {
                            if (!(ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || player.m_20310_(2))) {
                                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.disabled.modify_spawns"));
                                return;
                            }
                            Vec3i templateSize = TemplateData.get((ServerLevel)level).getConfiguredTemplate().getTemplate().m_163801_();
                            BlockPos.MutableBlockPos center = team.getIsland().getCenter().m_122032_();
                            center.m_142082_(templateSize.m_123341_() / 2, templateSize.m_123342_() / 2, templateSize.m_123343_() / 2);
                            if (msg.pos.m_123314_((Vec3i)center, (double)ConfigHandler.Utility.Spawns.range)) break;
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.position_too_far_away"));
                            return;
                        }
                    }
                    team.addPossibleSpawn(msg.pos);
                    network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.spawn_added", new Object[]{msg.pos.m_123341_(), msg.pos.m_123342_(), msg.pos.m_123343_()}));
                    return;
                }
                case REMOVE: {
                    if (level != level.m_142572_().m_129880_(ConfigHandler.Spawn.dimension)) {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.wrong_position"));
                        return;
                    }
                    Event.Result result = SkyblockHooks.onRemoveSpawn((ServerPlayer)player, (Team)team, (BlockPos)msg.pos);
                    switch (result) {
                        case DENY: {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.denied.modify_spawns0"));
                            return;
                        }
                        case DEFAULT: {
                            if (ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || player.m_20310_(2)) break;
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.disabled.modify_spawns"));
                            return;
                        }
                    }
                    if (!team.removePossibleSpawn(msg.pos)) {
                        TranslatableComponent answer = new TranslatableComponent("skyblockbuilder.command.error.remove_spawn0");
                        if (team.getPossibleSpawns().size() <= 1) {
                            answer.m_130946_(" ").m_7220_((Component)new TranslatableComponent("skyblockbuilder.command.error.remove_spawn1"));
                        }
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)answer);
                        return;
                    }
                    network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.spawn_removed", new Object[]{msg.pos.m_123341_(), msg.pos.m_123342_(), msg.pos.m_123343_()}));
                    return;
                }
            }
            ctx.setPacketHandled(true);
        });
    }

    public record Message(Type type, BlockPos pos) {
    }

    public static enum Type {
        ADD,
        REMOVE,
        RESET;

    }

    public static class Serializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)msg.type);
            buffer.m_130064_(msg.pos);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message((Type)buffer.m_130066_(Type.class), buffer.m_130135_());
        }
    }
}

