/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateTeam {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (!player.m_20310_(2)) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("missing_permissions", new Object[0]));
                return;
            }
            ServerLevel level = player.m_183503_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team"));
                return;
            }
            PlayerList playerList = level.m_142572_().m_6846_();
            Pair result = SkyblockHooks.onManageRemoveFromTeam(null, (Team)team, (Collection)msg.players.stream().map(arg_0 -> ((PlayerList)playerList).m_11259_(arg_0)).collect(Collectors.toList()));
            if (((Boolean)result.getLeft()).booleanValue()) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.denied.remove_players_from_team"));
                return;
            }
            if (team.getName().equalsIgnoreCase(msg.teamName)) {
                for (UUID id : msg.players) {
                    if (!team.hasPlayer(id)) continue;
                    data.removePlayerFromTeam(id);
                    ServerPlayer toRemove = playerList.m_11259_(id);
                    if (toRemove == null) continue;
                    if (ConfigHandler.Inventory.dropItems) {
                        RandomUtility.dropInventories((Player)toRemove);
                    }
                    WorldUtil.teleportToIsland((ServerPlayer)toRemove, (Team)data.getSpawn());
                }
            } else {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("player_not_in_team", new Object[0]));
                return;
            }
            network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.remove_multiple_players", new Object[]{msg.players.size(), team.getName()}));
        });
        ctx.setPacketHandled(true);
    }

    public record Message(String teamName, Set<UUID> players) {
    }

    public static class Serializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.teamName);
            buffer.m_130130_(msg.players.size());
            for (UUID id : msg.players) {
                buffer.m_130077_(id);
            }
        }

        public Message decode(FriendlyByteBuf buffer) {
            String teamName = buffer.m_130277_();
            int size = buffer.m_130242_();
            HashSet ids = Sets.newHashSet();
            for (int i = 0; i < size; ++i) {
                ids.add(buffer.m_130259_());
            }
            return new Message(teamName, ids);
        }
    }
}

