/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class VisitTeam {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (!ConfigHandler.Utility.Teleports.allowVisits) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.disabled.team_visit"));
                return;
            }
            ServerLevel level = player.m_183503_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeam(msg.team);
            if (team == null) {
                return;
            }
            if (!team.allowsVisits()) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.disabled.visit_team"));
                return;
            }
            if (team.equals((Object)data.getTeamFromPlayer((Player)player))) {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)new TranslatableComponent("skyblockbuilder.command.error.visit_own_team"));
                return;
            }
            WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
            network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)new TranslatableComponent("skyblockbuilder.command.success.visit_team", new Object[]{team.getName()}));
        });
        ctx.setPacketHandled(true);
    }

    public record Message(UUID team) {
    }

    public static class Serializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.team);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130259_());
        }
    }
}

