/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfPortalTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.TriPredicate;

public class TileAlfPortal
extends TileMod
implements IWandable {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> {
        record 1Matcher(TagKey<Block> tag, Direction.Axis displayedRotation, Block defaultBlock) implements IStateMatcher
        {
            public BlockState getDisplayedState(long ticks) {
                List<Block> blocks = StreamSupport.stream(Registry.f_122824_.m_206058_(this.tag).spliterator(), false).map(Holder::m_203334_).toList();
                if (blocks.isEmpty()) {
                    return Blocks.f_50752_.m_49966_();
                }
                BlockState block = blocks.contains(this.defaultBlock) ? this.defaultBlock.m_49966_() : blocks.get((int)(ticks / 20L % (long)blocks.size())).m_49966_();
                return block.m_61138_((Property)BlockStateProperties.f_61365_) ? (BlockState)block.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.displayedRotation()) : block;
            }

            public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
                return (blockGetter, pos, state) -> state.m_204336_(this.tag());
            }
        }
        1Matcher horizontal = new 1Matcher(ModTags.Blocks.LIVINGWOOD_LOGS, Direction.Axis.X, ModBlocks.livingwoodLog);
        1Matcher vertical = new 1Matcher(ModTags.Blocks.LIVINGWOOD_LOGS, Direction.Axis.Y, ModBlocks.livingwoodLog);
        1Matcher horizontalGlimmer = new 1Matcher(ModTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, Direction.Axis.X, ModBlocks.livingwoodLogGlimmering);
        1Matcher verticalGlimmer = new 1Matcher(ModTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, Direction.Axis.Y, ModBlocks.livingwoodLogGlimmering);
        return PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"_", "w", "g", "w", "_"}, {"W", " ", " ", " ", "W"}, {"G", " ", " ", " ", "G"}, {"W", " ", " ", " ", "W"}, {"_", "w", "0", "w", "_"}}, new Object[]{Character.valueOf('W'), vertical, Character.valueOf('w'), horizontal, Character.valueOf('G'), verticalGlimmer, Character.valueOf('g'), horizontalGlimmer, Character.valueOf('0'), ModBlocks.alfPortal});
    });
    public static final int MANA_COST = 500;
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    public static final String TAG_PORTAL_FLAG = "_elvenPortal";
    private final List<ItemStack> stacksIn = new ArrayList<ItemStack>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean explode = false;
    @Nullable
    private UUID breadPlayer = null;

    public TileAlfPortal(BlockPos pos, BlockState state) {
        super(ModTiles.ALF_PORTAL, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState blockState, TileAlfPortal self) {
        if (blockState.m_61143_(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF) {
            self.ticksOpen = 0;
            return;
        }
        AlfPortalState state = (AlfPortalState)((Object)blockState.m_61143_(BotaniaStateProps.ALFPORTAL_STATE));
        AlfPortalState newState = self.getValidState();
        ++self.ticksOpen;
        AABB aabb = self.getPortalAABB();
        boolean open = self.ticksOpen > 60;
        IXplatAbstractions.INSTANCE.fireElvenPortalUpdateEvent(self, aabb, open, self.stacksIn);
        if (self.ticksOpen > 60) {
            ++self.ticksSinceLastItem;
            if (level.f_46443_ && BotaniaConfig.client().elfPortalParticlesEnabled()) {
                self.blockParticle(state);
            }
            List items = level.m_45976_(ItemEntity.class, aabb);
            if (!level.f_46443_) {
                for (ItemEntity item : items) {
                    if (!item.m_6084_()) continue;
                    ItemStack stack = item.m_32055_();
                    if (IXplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).alfPortalSpawned) continue;
                    item.m_146870_();
                    if (self.validateItemUsage(item)) {
                        self.addItem(stack);
                    }
                    self.ticksSinceLastItem = 0;
                }
            }
            if (!level.f_46443_ && !self.stacksIn.isEmpty() && self.ticksSinceLastItem >= 4) {
                self.resolveRecipes();
            }
        }
        if (self.closeNow) {
            if (!level.f_46443_) {
                level.m_46597_(worldPosition, ModBlocks.alfPortal.m_49966_());
            }
            for (int i = 0; i < 36; ++i) {
                self.blockParticle(state);
            }
            self.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    self.blockParticle(state);
                }
            }
            if (!level.f_46443_) {
                level.m_46597_(worldPosition, (BlockState)blockState.m_61124_(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            }
        } else if (self.explode) {
            Player entity;
            level.m_46511_(null, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 2.0, (double)worldPosition.m_123343_() + 0.5, 3.0f, Explosion.BlockInteraction.BREAK);
            self.explode = false;
            if (!level.f_46443_ && self.breadPlayer != null && (entity = level.m_46003_(self.breadPlayer)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AlfPortalBreadTrigger.INSTANCE.trigger(serverPlayer, worldPosition);
            }
            self.breadPlayer = null;
        }
    }

    private boolean validateItemUsage(ItemEntity entity) {
        ItemStack inputStack = entity.m_32055_();
        for (Recipe recipe : ModRecipeTypes.getRecipes(this.f_58857_, ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            IElvenTradeRecipe tradeRecipe;
            if (!(recipe instanceof IElvenTradeRecipe) || !(tradeRecipe = (IElvenTradeRecipe)recipe).containsItem(inputStack)) continue;
            return true;
        }
        if (inputStack.m_150930_(Items.f_42406_)) {
            this.explode = true;
            this.breadPlayer = entity.m_32057_();
        }
        return false;
    }

    private void blockParticle(AlfPortalState state) {
        double dh;
        double dy = switch (this.f_58857_.f_46441_.nextInt(9)) {
            case 0 -> {
                dh = 0.0;
                yield 1.0;
            }
            case 1 -> {
                dh = 0.0;
                yield 2.0;
            }
            case 2 -> {
                dh = 0.0;
                yield 3.0;
            }
            case 3 -> {
                dh = -1.0;
                yield 1.0;
            }
            case 4 -> {
                dh = -1.0;
                yield 2.0;
            }
            case 5 -> {
                dh = -1.0;
                yield 3.0;
            }
            case 6 -> {
                dh = 1.0;
                yield 1.0;
            }
            case 7 -> {
                dh = 1.0;
                yield 2.0;
            }
            case 8 -> {
                dh = 1.0;
                yield 3.0;
            }
            default -> throw new AssertionError();
        };
        double dx = state == AlfPortalState.ON_X ? 0.0 : dh;
        double dz = state == AlfPortalState.ON_Z ? 0.0 : dh;
        float motionMul = 0.2f;
        WispParticleData data = WispParticleData.wisp((float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25));
        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.m_58899_().m_123341_() + dx, (double)this.m_58899_().m_123342_() + dy, (double)this.m_58899_().m_123343_() + dz, (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul));
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        AlfPortalState newState;
        AlfPortalState state = (AlfPortalState)((Object)this.m_58900_().m_61143_(BotaniaStateProps.ALFPORTAL_STATE));
        if (state == AlfPortalState.OFF && (newState = this.getValidState()) != AlfPortalState.OFF) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AlfPortalTrigger.INSTANCE.trigger(serverPlayer, serverPlayer.m_183503_(), this.m_58899_(), stack);
            }
            return true;
        }
        return false;
    }

    private AABB getPortalAABB() {
        AABB aabb = new AABB(this.f_58858_.m_142082_(-1, 1, 0), this.f_58858_.m_142082_(2, 4, 1));
        if (this.m_58900_().m_61143_(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.ON_X) {
            aabb = new AABB(this.f_58858_.m_142082_(0, 1, -1), this.f_58858_.m_142082_(1, 4, 2));
        }
        return aabb;
    }

    private void addItem(ItemStack stack) {
        int size = stack.m_41613_();
        stack.m_41764_(1);
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.m_41777_());
        }
    }

    public static Collection<IElvenTradeRecipe> elvenTradeRecipes(Level world) {
        return ModRecipeTypes.getRecipes(world, ModRecipeTypes.ELVEN_TRADE_TYPE).values();
    }

    private void resolveRecipes() {
        List<BlockPos> pylons = this.locatePylons();
        for (Recipe r : ModRecipeTypes.getRecipes(this.f_58857_, ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            IElvenTradeRecipe recipe;
            Optional<List<ItemStack>> match;
            if (!(r instanceof IElvenTradeRecipe) || !(match = (recipe = (IElvenTradeRecipe)r).match(this.stacksIn)).isPresent()) continue;
            if (!this.consumeMana(pylons, 500, false)) break;
            List<ItemStack> inputs = match.get();
            for (ItemStack stack : inputs) {
                this.stacksIn.remove(stack);
            }
            for (ItemStack output : recipe.getOutputs(inputs)) {
                this.spawnItem(output.m_41777_());
            }
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
        IXplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).alfPortalSpawned = true;
        this.f_58857_.m_7967_((Entity)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    public void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        cmp.m_128405_(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            CompoundTag stackcmp = stack.m_41739_(new CompoundTag());
            cmp.m_128365_(TAG_STACK + i, (Tag)stackcmp);
            ++i;
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag cmp) {
        super.m_142466_(cmp);
        int count = cmp.m_128451_(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            CompoundTag stackcmp = cmp.m_128469_(TAG_STACK + i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.m_128405_(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.ticksOpen = cmp.m_128451_(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.m_128451_(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private AlfPortalState getValidState() {
        Rotation rot = MULTIBLOCK.get().validate(this.f_58857_, this.m_58899_());
        if (rot == null) {
            return AlfPortalState.OFF;
        }
        this.lightPylons();
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> AlfPortalState.ON_Z;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> AlfPortalState.ON_X;
        };
    }

    public List<BlockPos> locatePylons() {
        int range = 5;
        return BlockPos.m_121990_((BlockPos)this.m_58899_().m_142082_(-range, -range, -range), (BlockPos)this.m_58899_().m_142082_(range, range, range)).filter(arg_0 -> ((Level)this.f_58857_).m_46805_(arg_0)).filter(p -> this.f_58857_.m_8055_(p).m_60713_(ModBlocks.naturaPylon) && this.f_58857_.m_8055_(p.m_7495_()).m_60734_() instanceof BlockPool).map(BlockPos::m_7949_).collect(Collectors.toList());
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        List<BlockPos> pylons = this.locatePylons();
        for (BlockPos pos : pylons) {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (!(tile instanceof TilePylon)) continue;
            TilePylon pylon = (TilePylon)tile;
            pylon.activated = true;
            pylon.centerPos = this.m_58899_();
        }
        if (this.ticksOpen == 50) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(List<BlockPos> pylons, int totalCost, boolean close) {
        ArrayList<TilePool> consumePools = new ArrayList<TilePool>();
        int consumed = 0;
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (BlockPos pos : pylons) {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (tile instanceof TilePylon) {
                TilePylon pylon = (TilePylon)tile;
                pylon.activated = true;
                pylon.centerPos = this.m_58899_();
            }
            if (!((tile = this.f_58857_.m_7702_(pos.m_7495_())) instanceof TilePool)) continue;
            TilePool pool = (TilePool)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.f_58857_.f_46443_) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (TilePool pool : consumePools) {
                pool.receiveMana(-costPer);
            }
            return true;
        }
        return false;
    }
}

