/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public abstract class ItemElementiumArmor
extends ItemManasteelArmor {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ModItems.elementiumHelm), new ItemStack((ItemLike)ModItems.elementiumChest), new ItemStack((ItemLike)ModItems.elementiumLegs), new ItemStack((ItemLike)ModItems.elementiumBoots)});

    public ItemElementiumArmor(EquipmentSlot type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getElementiumArmorMaterial(), props);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_elementium.png";
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ModItems.elementiumHelm);
            case EquipmentSlot.CHEST -> stack.m_150930_(ModItems.elementiumChest);
            case EquipmentSlot.LEGS -> stack.m_150930_(ModItems.elementiumLegs);
            case EquipmentSlot.FEET -> stack.m_150930_(ModItems.elementiumBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return new TranslatableComponent("botania.armorset.elementium.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        super.addArmorSetDescription(stack, list);
        list.add((Component)new TranslatableComponent("botania.armorset.elementium.desc").m_130940_(ChatFormatting.GRAY));
    }
}

