/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.item.TinyPotatoRenderEvent;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.client.ForgePlatformModel;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.network.IPacket;
import vazkii.botania.xplat.IClientXplatAbstractions;

public class ForgeClientXplatImpl
implements IClientXplatAbstractions {
    @Override
    public void fireRenderTinyPotato(BlockEntity potato, Component name, float tickDelta, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        MinecraftForge.EVENT_BUS.post((Event)new TinyPotatoRenderEvent(potato, name, tickDelta, ms, buffers, light, overlay));
    }

    @Override
    public void sendToServer(IPacket packet) {
        ForgePacketHandler.CHANNEL.sendToServer((Object)packet);
    }

    @Override
    @Nullable
    public IWandHUD findWandHud(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeClientCapabilities.WAND_HUD, level, pos, state, be);
    }

    @Override
    public BakedModel wrapPlatformModel(BakedModel original) {
        return new ForgePlatformModel(original);
    }

    @Override
    public void setFilterSave(AbstractTexture texture, boolean filter, boolean mipmap) {
        texture.setBlurMipmap(filter, mipmap);
    }

    @Override
    public void restoreLastFilter(AbstractTexture texture) {
        texture.restoreLastBlurMipmap();
    }

    @Override
    public void tessellateBlock(Level level, BlockState state, BlockPos pos, PoseStack ps, MultiBufferSource buffers, int overlay) {
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        for (RenderType type : RenderType.m_110506_()) {
            if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
            ForgeHooksClient.setRenderType((RenderType)type);
            renderer.m_110937_().m_111047_((BlockAndTintGetter)level, renderer.m_110910_(state), state, pos, ps, buffers.m_6299_(type), false, new Random(), state.m_60726_(pos), overlay);
        }
        ForgeHooksClient.setRenderType(null);
    }
}

