/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.MissingIngredients;
import org.cyclops.integratedcrafting.core.PendingCraftingJobResultIndexObserver;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingJobHandler {
    private final int maxProcessingJobs;
    private boolean blockingJobsMode;
    private final ICraftingResultsSink resultsSink;
    private final Collection<ICraftingProcessOverride> craftingProcessOverrides;
    private final Int2ObjectMap<CraftingJob> allCraftingJobs;
    private final Int2ObjectMap<CraftingJob> processingCraftingJobs;
    private final Int2ObjectMap<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> processingCraftingJobsPendingIngredients;
    private final Int2ObjectMap<CraftingJob> pendingCraftingJobs;
    private final Object2IntMap<IngredientComponent<?, ?>> ingredientObserverCounters;
    private final Map<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> ingredientObservers;
    private final List<IngredientComponent<?, ?>> observersPendingCreation;
    private final List<IngredientComponent<?, ?>> observersPendingDeletion;
    private final Int2ObjectMap<CraftingJob> finishedCraftingJobs;
    private final Map<IngredientComponent<?, ?>, Direction> ingredientComponentTargetOverrides;
    private final Int2IntMap nonBlockingJobsRunningAmount;

    public CraftingJobHandler(int maxProcessingJobs, boolean blockingJobsMode, Collection<ICraftingProcessOverride> craftingProcessOverrides, ICraftingResultsSink resultsSink) {
        this.maxProcessingJobs = maxProcessingJobs;
        this.blockingJobsMode = blockingJobsMode;
        this.resultsSink = resultsSink;
        this.craftingProcessOverrides = craftingProcessOverrides;
        this.allCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobs = new Int2ObjectOpenHashMap();
        this.pendingCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobsPendingIngredients = new Int2ObjectOpenHashMap();
        this.ingredientObserverCounters = new Object2IntOpenHashMap();
        this.ingredientObservers = Maps.newIdentityHashMap();
        this.observersPendingCreation = Lists.newArrayList();
        this.observersPendingDeletion = Lists.newArrayList();
        this.finishedCraftingJobs = new Int2ObjectOpenHashMap();
        this.ingredientComponentTargetOverrides = Maps.newIdentityHashMap();
        this.nonBlockingJobsRunningAmount = new Int2IntOpenHashMap();
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128379_("blockingJobsMode", this.blockingJobsMode);
        ListTag processingCraftingJobs = new ListTag();
        for (CraftingJob processingCraftingJob : this.processingCraftingJobs.values()) {
            CompoundTag entriesTag = new CompoundTag();
            entriesTag.m_128365_("craftingJob", (Tag)CraftingJob.serialize(processingCraftingJob));
            List list = (List)this.processingCraftingJobsPendingIngredients.get(processingCraftingJob.getId());
            ListTag pendingEntries = new ListTag();
            for (Map ingredients : list) {
                ListTag pendingIngredientInstances = new ListTag();
                for (Map.Entry ingredientComponentListEntry : ingredients.entrySet()) {
                    CompoundTag ingredientInstance = new CompoundTag();
                    IngredientComponent ingredientComponent = (IngredientComponent)ingredientComponentListEntry.getKey();
                    ingredientInstance.m_128359_("ingredientComponent", ingredientComponent.getRegistryName().toString());
                    ListTag instances = new ListTag();
                    IIngredientSerializer serializer = ingredientComponent.getSerializer();
                    for (IPrototypedIngredient prototypedIngredient : (List)ingredientComponentListEntry.getValue()) {
                        CompoundTag instance = new CompoundTag();
                        instance.m_128365_("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
                        instance.m_128365_("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
                        instances.add((Object)instance);
                    }
                    ingredientInstance.m_128365_("instances", (Tag)instances);
                    pendingIngredientInstances.add((Object)ingredientInstance);
                }
                pendingEntries.add((Object)pendingIngredientInstances);
            }
            entriesTag.m_128365_("pendingIngredientInstanceEntries", (Tag)pendingEntries);
            processingCraftingJobs.add((Object)entriesTag);
        }
        tag.m_128365_("processingCraftingJobs", (Tag)processingCraftingJobs);
        ListTag pendingCraftingJobs = new ListTag();
        for (Object craftingJob : this.pendingCraftingJobs.values()) {
            pendingCraftingJobs.add((Object)CraftingJob.serialize((CraftingJob)craftingJob));
        }
        tag.m_128365_("pendingCraftingJobs", (Tag)pendingCraftingJobs);
        CompoundTag targetOverrides = new CompoundTag();
        for (Map.Entry entry : this.ingredientComponentTargetOverrides.entrySet()) {
            targetOverrides.m_128405_(((IngredientComponent)entry.getKey()).getName().toString(), ((Direction)entry.getValue()).ordinal());
        }
        tag.m_128365_("targetOverrides", (Tag)targetOverrides);
        CompoundTag nonBlockingJobsRunningAmount = new CompoundTag();
        for (Int2IntMap.Entry entry : this.nonBlockingJobsRunningAmount.int2IntEntrySet()) {
            nonBlockingJobsRunningAmount.m_128405_(String.valueOf(entry.getIntKey()), entry.getIntValue());
        }
        tag.m_128365_("nonBlockingJobsRunningAmount", (Tag)nonBlockingJobsRunningAmount);
    }

    public void readFromNBT(CompoundTag tag) {
        Object craftingJobInstance;
        if (tag.m_128441_("blockingJobsMode")) {
            this.blockingJobsMode = tag.m_128471_("blockingJobsMode");
        }
        ListTag processingCraftingJobs = tag.m_128437_("processingCraftingJobs", 10);
        for (Object entry : processingCraftingJobs) {
            CompoundTag entryTag = (CompoundTag)entry;
            ArrayList pendingIngredientInstanceEntries = Lists.newArrayList();
            if (entryTag.m_128441_("pendingIngredientInstances")) {
                IdentityHashMap pendingIngredientInstances = Maps.newIdentityHashMap();
                ListTag pendingIngredientsList = entryTag.m_128437_("pendingIngredientInstances", 10);
                Iterator iterator = pendingIngredientsList.iterator();
                while (iterator.hasNext()) {
                    Tag pendingIngredient = (Tag)iterator.next();
                    CompoundTag pendingIngredientTag = (CompoundTag)pendingIngredient;
                    String componentName = pendingIngredientTag.m_128461_("ingredientComponent");
                    IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
                    if (ingredientComponent == null) {
                        throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
                    }
                    IIngredientSerializer serializer = ingredientComponent.getSerializer();
                    ArrayList pendingIngredients = Lists.newArrayList();
                    for (Tag instanceTagUnsafe : pendingIngredientTag.m_128437_("instances", 10)) {
                        CompoundTag instanceTag = (CompoundTag)instanceTagUnsafe;
                        Object instance = serializer.deserializeInstance(instanceTag.m_128423_("prototype"));
                        Object condition = serializer.deserializeCondition(instanceTag.m_128423_("condition"));
                        pendingIngredients.add(new PrototypedIngredient(ingredientComponent, instance, condition));
                    }
                    pendingIngredientInstances.put(ingredientComponent, pendingIngredients);
                }
                pendingIngredientInstanceEntries.add(pendingIngredientInstances);
            } else {
                ListTag ingredientsEntries = entryTag.m_128437_("pendingIngredientInstanceEntries", 9);
                for (Tag ingredientEntry : ingredientsEntries) {
                    ListTag pendingIngredientsList = (ListTag)ingredientEntry;
                    IdentityHashMap pendingIngredientInstances = Maps.newIdentityHashMap();
                    for (Tag pendingIngredient : pendingIngredientsList) {
                        CompoundTag pendingIngredientTag = (CompoundTag)pendingIngredient;
                        String componentName = pendingIngredientTag.m_128461_("ingredientComponent");
                        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
                        if (ingredientComponent == null) {
                            throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
                        }
                        IIngredientSerializer serializer = ingredientComponent.getSerializer();
                        ArrayList pendingIngredients = Lists.newArrayList();
                        for (Tag instanceTagUnsafe : pendingIngredientTag.m_128437_("instances", 10)) {
                            CompoundTag instanceTag = (CompoundTag)instanceTagUnsafe;
                            Object instance = serializer.deserializeInstance(instanceTag.m_128423_("prototype"));
                            Object condition = serializer.deserializeCondition(instanceTag.m_128423_("condition"));
                            pendingIngredients.add(new PrototypedIngredient(ingredientComponent, instance, condition));
                        }
                        pendingIngredientInstances.put(ingredientComponent, pendingIngredients);
                    }
                    pendingIngredientInstanceEntries.add(pendingIngredientInstances);
                }
            }
            CraftingJob craftingJob = CraftingJob.deserialize(entryTag.m_128469_("craftingJob"));
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), (Object)pendingIngredientInstanceEntries);
        }
        ListTag pendingCraftingJobs = tag.m_128437_("pendingCraftingJobs", 10);
        for (Tag craftingJob : pendingCraftingJobs) {
            craftingJobInstance = CraftingJob.deserialize((CompoundTag)craftingJob);
            this.pendingCraftingJobs.put(((CraftingJob)craftingJobInstance).getId(), craftingJobInstance);
            this.allCraftingJobs.put(((CraftingJob)craftingJobInstance).getId(), craftingJobInstance);
        }
        for (Object valueEntries : this.processingCraftingJobsPendingIngredients.values()) {
            craftingJobInstance = valueEntries.iterator();
            while (craftingJobInstance.hasNext()) {
                Map value = (Map)craftingJobInstance.next();
                this.observersPendingCreation.addAll(value.keySet());
            }
        }
        this.ingredientComponentTargetOverrides.clear();
        CompoundTag targetOverrides = tag.m_128469_("targetOverrides");
        for (String componentName : targetOverrides.m_128431_()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            this.ingredientComponentTargetOverrides.put(component, Direction.values()[targetOverrides.m_128451_(componentName)]);
        }
        this.nonBlockingJobsRunningAmount.clear();
        CompoundTag nonBlockingJobsRunningAmount = tag.m_128469_("nonBlockingJobsRunningAmount");
        for (String key : nonBlockingJobsRunningAmount.m_128431_()) {
            int craftingJobId = Integer.parseInt(key);
            int amount = nonBlockingJobsRunningAmount.m_128451_(key);
            this.nonBlockingJobsRunningAmount.put(craftingJobId, amount);
        }
    }

    public boolean setBlockingJobsMode(boolean blockingJobsMode) {
        if (this.blockingJobsMode != blockingJobsMode) {
            this.blockingJobsMode = blockingJobsMode;
            return true;
        }
        return false;
    }

    public boolean isBlockingJobsMode() {
        return this.blockingJobsMode;
    }

    public boolean canScheduleCraftingJobs() {
        return this.pendingCraftingJobs.size() < GeneralConfig.maxPendingCraftingJobs;
    }

    public void scheduleCraftingJob(CraftingJob craftingJob) {
        this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        if (!this.isBlockingJobsMode()) {
            this.nonBlockingJobsRunningAmount.put(craftingJob.getId(), 0);
        }
    }

    public Int2ObjectMap<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> getProcessingCraftingJobsPendingIngredients() {
        return this.processingCraftingJobsPendingIngredients;
    }

    public Int2ObjectMap<CraftingJob> getProcessingCraftingJobsRaw() {
        return this.processingCraftingJobs;
    }

    public Collection<CraftingJob> getProcessingCraftingJobs() {
        return this.getProcessingCraftingJobsRaw().values();
    }

    public Collection<CraftingJob> getPendingCraftingJobs() {
        return this.pendingCraftingJobs.values();
    }

    public void unmarkCraftingJobProcessing(CraftingJob craftingJob) {
        if (this.processingCraftingJobs.remove(craftingJob.getId()) != null) {
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
            this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        }
    }

    public void addCraftingJobProcessingPendingIngredientsEntry(CraftingJob craftingJob, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> pendingIngredients) {
        if (pendingIngredients.isEmpty()) {
            this.processingCraftingJobs.remove(craftingJob.getId());
            this.allCraftingJobs.remove(craftingJob.getId());
            this.nonBlockingJobsRunningAmount.remove(craftingJob.getId());
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
        } else {
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            List pendingIngredientsEntries = (List)this.processingCraftingJobsPendingIngredients.get(craftingJob.getId());
            if (pendingIngredientsEntries == null) {
                pendingIngredientsEntries = Lists.newArrayList();
                this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), (Object)pendingIngredientsEntries);
            }
            pendingIngredientsEntries.add(pendingIngredients);
        }
    }

    public List<IngredientComponent<?, ?>> getObserversPendingDeletion() {
        return this.observersPendingDeletion;
    }

    protected <T, M> void registerIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
            ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            PendingCraftingJobResultIndexObserver<T, M> observer = new PendingCraftingJobResultIndexObserver<T, M>(ingredientComponent, this, craftingNetwork);
            ingredientsNetwork.addObserver(observer);
            ingredientsNetwork.scheduleObservation();
            this.ingredientObservers.put(ingredientComponent, observer);
        }
        this.ingredientObserverCounters.put(ingredientComponent, count + 1);
    }

    protected <T, M> void unregisterIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        this.ingredientObserverCounters.put(ingredientComponent, --count);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
            IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?> observer = this.ingredientObservers.remove(ingredientComponent);
            ingredientsNetwork.removeObserver(observer);
        }
    }

    public void onCraftingJobFinished(CraftingJob craftingJob) {
        this.processingCraftingJobs.remove(craftingJob.getId());
        this.pendingCraftingJobs.remove(craftingJob.getId());
        this.finishedCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public void markCraftingJobFinished(int craftingJobId) {
        this.processingCraftingJobsPendingIngredients.remove(craftingJobId);
        this.processingCraftingJobs.remove(craftingJobId);
        this.pendingCraftingJobs.remove(craftingJobId);
        CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
        this.finishedCraftingJobs.put(craftingJobId, (Object)craftingJob);
        craftingJob.setAmount(0);
    }

    public void reRegisterObservers(INetwork network) {
        for (Map.Entry<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> entry : this.ingredientObservers.entrySet()) {
            IPositionedAddonsNetworkIngredients<?, ?> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, entry.getKey());
            ingredientsNetwork.addObserver(entry.getValue());
        }
    }

    public void onCraftingJobEntryFinished(ICraftingNetwork craftingNetwork, int craftingJobId) {
        CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
        craftingJob.setAmount(craftingJob.getAmount() - 1);
        if (this.nonBlockingJobsRunningAmount.containsKey(craftingJobId)) {
            this.nonBlockingJobsRunningAmount.put(craftingJobId, this.nonBlockingJobsRunningAmount.get(craftingJobId) - 1);
        }
        for (CraftingJob dependent : craftingNetwork.getCraftingJobDependencyGraph().getDependents(craftingJob)) {
            dependent.setIgnoreDependencyCheck(true);
        }
    }

    public void update(INetwork network, int channel, PartPos targetPos) {
        int processingJobs;
        if (this.observersPendingCreation.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingCreation) {
                this.registerIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingCreation.clear();
        }
        if (this.observersPendingDeletion.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingDeletion) {
                this.unregisterIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingDeletion.clear();
        }
        if (this.finishedCraftingJobs.size() > 0) {
            for (Object finishedCraftingJob : this.finishedCraftingJobs.values()) {
                if (((CraftingJob)finishedCraftingJob).getAmount() == 0) {
                    ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
                    iCraftingNetwork.onCraftingJobFinished((CraftingJob)finishedCraftingJob);
                    this.allCraftingJobs.remove(((CraftingJob)finishedCraftingJob).getId());
                    this.nonBlockingJobsRunningAmount.remove(((CraftingJob)finishedCraftingJob).getId());
                    continue;
                }
                this.pendingCraftingJobs.put(((CraftingJob)finishedCraftingJob).getId(), finishedCraftingJob);
            }
            this.finishedCraftingJobs.clear();
        }
        if ((processingJobs = this.getProcessingCraftingJobs().size()) > 0) {
            for (IngredientComponent ingredientComponent : this.ingredientObservers.keySet()) {
                IPositionedAddonsNetworkIngredients ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
                ingredientsNetwork.scheduleObservation();
            }
        }
        if (!this.nonBlockingJobsRunningAmount.isEmpty()) {
            for (Int2IntMap.Entry entry : this.nonBlockingJobsRunningAmount.int2IntEntrySet()) {
                int craftingJobId = entry.getIntKey();
                int runningAmount = entry.getIntValue();
                CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
                if (runningAmount <= 0 || runningAmount >= craftingJob.getAmount()) continue;
                this.insertLoopNonBlocking(network, channel, targetPos, craftingJob);
            }
        }
        if (processingJobs < this.maxProcessingJobs) {
            CraftingJob startingCraftingJob = null;
            ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            CraftingJobDependencyGraph dependencyGraph = iCraftingNetwork.getCraftingJobDependencyGraph();
            for (CraftingJob craftingJob : this.getPendingCraftingJobs()) {
                Pair<Map<IngredientComponent<?, ?>, List<?>>, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>>> inputs;
                if (dependencyGraph.hasDependencies(craftingJob) && !craftingJob.isIgnoreDependencyCheck()) continue;
                if (craftingJob.isIgnoreDependencyCheck()) {
                    craftingJob.setIgnoreDependencyCheck(false);
                }
                if (((Map)(inputs = CraftingHelpers.getRecipeInputs(CraftingHelpers.getNetworkStorageGetter(network, craftingJob.getChannel(), false), craftingJob.getRecipe(), true, Maps.newIdentityHashMap(), Maps.newIdentityHashMap(), true, 1L)).getRight()).isEmpty()) {
                    if (this.insertCrafting(targetPos, (IMixedIngredients)new MixedIngredients((Map)inputs.getLeft()), network, channel, true)) {
                        startingCraftingJob = craftingJob;
                        startingCraftingJob.setInvalidInputs(false);
                        break;
                    }
                    craftingJob.setInvalidInputs(true);
                    continue;
                }
                if (craftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent component : ((Map)inputs.getRight()).keySet()) {
                        this.registerIngredientObserver(component, network);
                        MissingIngredients missingIngredients = (MissingIngredients)((Map)inputs.getRight()).get(component);
                        block7: for (MissingIngredients.Element element : missingIngredients.getElements()) {
                            if (!element.isInputReusable()) continue;
                            for (MissingIngredients.PrototypedWithRequested alternative : element.getAlternatives()) {
                                if (CraftingHelpers.isCrafting(iCraftingNetwork, channel, alternative.getRequestedPrototype().getComponent(), alternative.getRequestedPrototype().getPrototype(), alternative.getRequestedPrototype().getCondition())) break;
                                CraftingJob craftingJob2 = CraftingHelpers.calculateAndScheduleCraftingJob(network, channel, alternative.getRequestedPrototype().getComponent(), alternative.getRequestedPrototype().getPrototype(), alternative.getRequestedPrototype().getCondition(), true, true, CraftingHelpers.getGlobalCraftingJobIdentifier(), null);
                                if (craftingJob2 == null) continue;
                                craftingJob.addDependency(craftingJob2);
                                continue block7;
                            }
                        }
                    }
                }
                craftingJob.setLastMissingIngredients((Map)inputs.getRight());
            }
            if (startingCraftingJob != null) {
                boolean blockingMode;
                boolean bl;
                if (!startingCraftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent ingredientComponent : startingCraftingJob.getLastMissingIngredients().keySet()) {
                        this.unregisterIngredientObserver(ingredientComponent, network);
                    }
                    startingCraftingJob.setLastMissingIngredients(Maps.newIdentityHashMap());
                }
                if ((bl = this.consumeAndInsertCrafting(blockingMode = !this.nonBlockingJobsRunningAmount.containsKey(startingCraftingJob.getId()) || startingCraftingJob.getAmount() == 1, network, channel, targetPos, startingCraftingJob)) && !blockingMode) {
                    this.nonBlockingJobsRunningAmount.put(startingCraftingJob.getId(), 1);
                    this.insertLoopNonBlocking(network, channel, targetPos, startingCraftingJob);
                }
            }
        }
    }

    protected boolean insertCrafting(PartPos target, IMixedIngredients ingredients, INetwork network, int channel, boolean simulate) {
        Function<IngredientComponent<?, ?>, PartPos> targetGetter = this.getTargetGetter(target);
        for (ICraftingProcessOverride craftingProcessOverride : this.craftingProcessOverrides) {
            if (!craftingProcessOverride.isApplicable(target)) continue;
            return craftingProcessOverride.craft(targetGetter, ingredients, this.resultsSink, simulate);
        }
        return CraftingHelpers.insertCrafting(targetGetter, ingredients, network, channel, simulate);
    }

    protected void insertLoopNonBlocking(INetwork network, int channel, PartPos targetPos, CraftingJob craftingJob) {
        IMixedIngredients ingredientsSimulated;
        while (this.nonBlockingJobsRunningAmount.get(craftingJob.getId()) < craftingJob.getAmount() && (ingredientsSimulated = CraftingHelpers.getRecipeInputs(network, craftingJob.getChannel(), craftingJob.getRecipe(), true, 1L)) != null && this.insertCrafting(targetPos, ingredientsSimulated, network, channel, true) && this.consumeAndInsertCrafting(true, network, channel, targetPos, craftingJob)) {
            this.nonBlockingJobsRunningAmount.put(craftingJob.getId(), this.nonBlockingJobsRunningAmount.get(craftingJob.getId()) + 1);
        }
    }

    protected boolean consumeAndInsertCrafting(boolean blockingMode, INetwork network, int channel, PartPos targetPos, CraftingJob startingCraftingJob) {
        IMixedIngredients ingredients = CraftingHelpers.getRecipeInputs(network, startingCraftingJob.getChannel(), startingCraftingJob.getRecipe(), false, 1L);
        if (ingredients != null) {
            this.pendingCraftingJobs.remove(startingCraftingJob.getId());
            this.addCraftingJobProcessingPendingIngredientsEntry(startingCraftingJob, CraftingHelpers.getRecipeOutputs(startingCraftingJob.getRecipe()));
            for (IngredientComponent component : startingCraftingJob.getRecipe().getOutput().getComponents()) {
                this.registerIngredientObserver(component, network);
            }
            if (!this.insertCrafting(targetPos, ingredients, network, channel, false)) {
                for (IngredientComponent component : startingCraftingJob.getRecipe().getOutput().getComponents()) {
                    this.unregisterIngredientObserver(component, network);
                }
                startingCraftingJob.setInvalidInputs(true);
                this.unmarkCraftingJobProcessing(startingCraftingJob);
                return false;
            }
            return true;
        }
        IntegratedCrafting.clog(Level.WARN, "Failed to extract ingredients for crafting job " + startingCraftingJob.getId());
        return false;
    }

    public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
        if (this.pendingCraftingJobs.containsKey(craftingJobId)) {
            CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
            if (craftingJob != null && craftingJob.isInvalidInputs()) {
                return CraftingJobStatus.INVALID_INPUTS;
            }
            CraftingJobDependencyGraph dependencyGraph = network.getCraftingJobDependencyGraph();
            if (dependencyGraph.hasDependencies(craftingJobId)) {
                return CraftingJobStatus.PENDING_DEPENDENCIES;
            }
            if (!craftingJob.getLastMissingIngredients().isEmpty()) {
                return CraftingJobStatus.PENDING_INGREDIENTS;
            }
            return CraftingJobStatus.PENDING_INTERFACE;
        }
        if (this.processingCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.PROCESSING;
        }
        if (this.finishedCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.FINISHED;
        }
        return CraftingJobStatus.UNKNOWN;
    }

    public Int2ObjectMap<CraftingJob> getAllCraftingJobs() {
        return this.allCraftingJobs;
    }

    public void setIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent, @Nullable Direction side) {
        if (side == null) {
            this.ingredientComponentTargetOverrides.remove(ingredientComponent);
        } else {
            this.ingredientComponentTargetOverrides.put(ingredientComponent, side);
        }
    }

    @Nullable
    public Direction getIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent) {
        return this.ingredientComponentTargetOverrides.get(ingredientComponent);
    }

    public Function<IngredientComponent<?, ?>, PartPos> getTargetGetter(PartPos defaultPosition) {
        return ingredientComponent -> {
            Direction sideOverride = this.ingredientComponentTargetOverrides.get(ingredientComponent);
            if (sideOverride == null) {
                return defaultPosition;
            }
            return PartPos.of((DimPos)defaultPosition.getPos(), (Direction)sideOverride);
        };
    }
}

