/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers;

import com.ultramega.botanypotstiers.PotTiers;
import com.ultramega.botanypotstiers.block.TieredBlockBotanyPot;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotMenu;
import com.ultramega.botanypotstiers.data.recipes.crop.BasicCropSerializer;
import com.ultramega.botanypotstiers.data.recipes.fertilizer.BasicFertilizerSerializer;
import com.ultramega.botanypotstiers.data.recipes.potinteraction.BasicPotInteractionSerializer;
import com.ultramega.botanypotstiers.data.recipes.soil.BasicSoilSerializer;
import java.util.Set;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class Content
extends RegistryDataProvider {
    public Content() {
        super("botanypotstiers");
        this.withCreativeTab(() -> (ItemLike)Services.REGISTRIES.items().get(new ResourceLocation("botanypotstiers", "elite_terracotta_botany_pot")));
        this.withAutoItemBlocks();
        this.bindBlockRenderLayers();
        this.recipeTypes.add("soil");
        this.recipeTypes.add("crop");
        this.recipeTypes.add("pot_interaction");
        this.recipeTypes.add("fertilizer");
        this.recipeSerializers.add(() -> BasicSoilSerializer.SERIALIZER, "soil");
        this.recipeSerializers.add(() -> BasicCropSerializer.SERIALIZER, "crop");
        this.recipeSerializers.add(() -> BasicPotInteractionSerializer.SERIALIZER, "pot_interaction");
        this.recipeSerializers.add(() -> BasicFertilizerSerializer.SERIALIZER, "fertilizer");
        for (PotTiers tier : PotTiers.values()) {
            this.blocks.add(() -> new TieredBlockBotanyPot(tier, false), tier.getName() + "_terracotta_botany_pot");
            this.blocks.add(() -> new TieredBlockBotanyPot(tier, true), tier.getName() + "_terracotta_hopper_botany_pot");
            for (DyeColor color : DyeColor.values()) {
                BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)color.m_41069_()).m_60913_(1.25f, 4.2f).m_60955_();
                this.blocks.add(() -> new TieredBlockBotanyPot(tier, properties, false), tier.getName() + "_" + color.m_41065_() + "_terracotta_botany_pot");
                this.blocks.add(() -> new TieredBlockBotanyPot(tier, properties, true), tier.getName() + "_" + color.m_41065_() + "_terracotta_hopper_botany_pot");
                this.blocks.add(() -> new TieredBlockBotanyPot(tier, properties, false), tier.getName() + "_" + color.m_41065_() + "_concrete_botany_pot");
                this.blocks.add(() -> new TieredBlockBotanyPot(tier, properties, true), tier.getName() + "_" + color.m_41065_() + "_concrete_hopper_botany_pot");
                this.blocks.add(() -> new TieredBlockBotanyPot(tier, properties, false), tier.getName() + "_" + color.m_41065_() + "_glazed_terracotta_botany_pot");
                this.blocks.add(() -> new TieredBlockBotanyPot(tier, properties, true), tier.getName() + "_" + color.m_41065_() + "_glazed_terracotta_hopper_botany_pot");
            }
        }
        for (PotTiers tier : PotTiers.values()) {
            this.blockEntities.add(() -> (BlockEntityType)Services.CONSTRUCTS.blockEntityType((pos, state) -> new TieredBlockEntityBotanyPot(tier, (BlockPos)pos, (BlockState)state), this::getAllPots).get(), tier.getName() + "_botany_pot");
        }
        this.menus.add(() -> Services.CONSTRUCTS.menuType(TieredBotanyPotMenu::fromNetwork), "pot_menu");
    }

    private Set<Block> getAllPots() {
        return this.blocks.getEntries().values().stream().filter(b -> b instanceof TieredBlockBotanyPot).collect(Collectors.toSet());
    }
}

