/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block;

import com.ultramega.botanypotstiers.Constants;
import com.ultramega.botanypotstiers.PotTiers;
import com.ultramega.botanypotstiers.TieredBotanyPotHelper;
import com.ultramega.botanypotstiers.block.TieredBlockBotanyPot;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotContainer;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotMenu;
import com.ultramega.botanypotstiers.data.recipes.crop.Crop;
import com.ultramega.botanypotstiers.data.recipes.soil.Soil;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.entity.WorldlyInventoryBlockEntity;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TieredBlockEntityBotanyPot
extends WorldlyInventoryBlockEntity<TieredBotanyPotContainer> {
    protected int growthTime = -1;
    protected boolean doneGrowing = false;
    protected int prevComparatorLevel = 0;
    protected int comparatorLevel = 0;
    protected int harvestDelay = -1;
    protected int exportDelay = -1;
    final Random rng = new Random();
    private long rngSeed;
    public final PotTiers tier;

    public TieredBlockEntityBotanyPot(PotTiers tier, BlockPos pos, BlockState state) {
        super((BlockEntityType)RegistryObject.deferred((Registry)Registry.f_122830_, (String)"botanypotstiers", (String)(tier.getName() + "_botany_pot")).cast().get(), pos, state);
        this.tier = tier;
        this.refreshRandom();
    }

    public boolean isHopper() {
        Block block;
        if (this.m_58904_() != null && (block = this.m_58904_().m_8055_(this.m_58899_()).m_60734_()) instanceof TieredBlockBotanyPot) {
            TieredBlockBotanyPot potBlock = (TieredBlockBotanyPot)block;
            return potBlock.hasInventory();
        }
        return false;
    }

    public void refreshRandom() {
        this.rngSeed = Constants.RANDOM.nextLong();
        this.rng.setSeed(this.rngSeed);
    }

    @Nullable
    public Crop getCrop() {
        return ((TieredBotanyPotContainer)this.getInventory()).getCrop();
    }

    @Nullable
    public Soil getSoil() {
        return ((TieredBotanyPotContainer)this.getInventory()).getSoil();
    }

    public boolean isGrowing() {
        return this.growthTime > 0;
    }

    public boolean areGrowthConditionsMet() {
        return TieredBotanyPotHelper.canCropGrow(this.f_58857_, this.m_58899_(), this, this.getSoil(), this.getCrop());
    }

    public boolean isCropHarvestable() {
        return this.doneGrowing;
    }

    public int getLightLevel() {
        Soil soil = this.getSoil();
        Crop crop = this.getCrop();
        int soilLight = soil != null ? soil.getLightLevel(this.f_58857_, this.m_58899_(), this) : 0;
        int cropLight = crop != null ? crop.getLightLevel(this.f_58857_, this.m_58899_(), this) : 0;
        return Math.max(soilLight, cropLight);
    }

    public int getGrowthTime() {
        return this.growthTime;
    }

    public int getComparatorLevel() {
        return this.comparatorLevel;
    }

    public boolean isValidSoil(ItemStack stack) {
        return TieredBotanyPotHelper.findSoil(this.f_58857_, this.m_58899_(), this, stack) != null;
    }

    public boolean isValidSeed(ItemStack stack) {
        return TieredBotanyPotHelper.findCrop(this.f_58857_, this.m_58899_(), this, stack) != null;
    }

    public boolean attemptAutoHarvest() {
        boolean didCollect = false;
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && this.getCrop() != null) {
            ContainerInventoryAccess inventory = new ContainerInventoryAccess((Container)((TieredBotanyPotContainer)this.getInventory()));
            this.rng.setSeed(this.rngSeed);
            for (ItemStack drop : TieredBotanyPotHelper.generateDrop(this.rng, this.f_58857_, this.m_58899_(), this, this.getCrop())) {
                if (drop.m_41619_()) continue;
                drop.m_41764_(drop.m_41613_() * this.tier.getMultiplier());
                int originalSize = drop.m_41613_();
                for (int slot : TieredBotanyPotContainer.STORAGE_SLOT) {
                    if (drop.m_41619_()) break;
                    drop = inventory.insert(slot, drop, Direction.UP, true, true);
                }
                if (drop.m_41613_() == originalSize) continue;
                didCollect = true;
            }
        }
        return didCollect;
    }

    private void attemptExport() {
        IInventoryAccess exportTo;
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && (exportTo = Services.INVENTORY_HELPER.getInventory(this.m_58904_(), this.m_58899_().m_7495_(), Direction.UP)) != null) {
            block0: for (int potSlotId : TieredBotanyPotContainer.STORAGE_SLOT) {
                ItemStack potStack = ((TieredBotanyPotContainer)this.getInventory()).m_8020_(potSlotId);
                if (potStack.m_41619_()) continue;
                for (int exportSlotId : exportTo.getAvailableSlots()) {
                    if (exportTo.insert(exportSlotId, potStack, Direction.UP, false).m_41613_() == potStack.m_41613_()) continue;
                    ((TieredBotanyPotContainer)this.getInventory()).m_6836_(potSlotId, exportTo.insert(exportSlotId, potStack, Direction.UP, true));
                    continue block0;
                }
            }
        }
    }

    public static void tickPot(Level level, BlockPos pos, BlockState state, TieredBlockEntityBotanyPot pot) {
        if (pot.m_58901_() || pot.m_58904_() == null) {
            return;
        }
        ((TieredBotanyPotContainer)pot.getInventory()).update();
        Soil soil = pot.getSoil();
        Crop crop = pot.getCrop();
        if (soil != null) {
            soil.onTick(level, pos, pot);
        }
        if (crop != null) {
            crop.onTick(level, pos, pot);
        }
        if (pot.isHopper()) {
            if (pot.exportDelay > 0) {
                --pot.exportDelay;
            }
            if (pot.harvestDelay > 0) {
                --pot.harvestDelay;
            }
            if (pot.isCropHarvestable() && crop != null && pot.harvestDelay < 1) {
                if (pot.attemptAutoHarvest()) {
                    pot.resetGrowth();
                }
                pot.harvestDelay = 100;
            }
            if (pot.exportDelay < 1) {
                pot.attemptExport();
                pot.exportDelay = 20;
            }
        }
        if (soil != null && crop != null && pot.areGrowthConditionsMet()) {
            if (!pot.doneGrowing) {
                boolean finishedGrowing;
                ++pot.growthTime;
                soil.onGrowthTick(level, pos, pot, crop);
                crop.onGrowthTick(level, pos, pot, soil);
                pot.prevComparatorLevel = pot.comparatorLevel;
                pot.comparatorLevel = Mth.m_14143_((float)(15.0f * ((float)pot.growthTime / (float)((TieredBotanyPotContainer)pot.getInventory()).getRequiredGrowthTime())));
                boolean bl = finishedGrowing = pot.growthTime >= ((TieredBotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
                if (pot.doneGrowing != finishedGrowing) {
                    pot.doneGrowing = finishedGrowing;
                    pot.markDirty();
                }
            }
        } else if (pot.growthTime != -1 || pot.doneGrowing || pot.comparatorLevel != 0) {
            pot.resetGrowth();
        }
        if (pot.comparatorLevel != pot.prevComparatorLevel) {
            pot.prevComparatorLevel = pot.comparatorLevel;
            pot.f_58857_.m_46717_(pot.f_58858_, pot.m_58900_().m_60734_());
        }
    }

    public void resetGrowth() {
        this.growthTime = -1;
        this.comparatorLevel = 0;
        this.prevComparatorLevel = 0;
        this.doneGrowing = false;
        this.refreshRandom();
        this.markDirty();
    }

    public void markDirty() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            super.markDirty();
            WorldHelper.updateBlockEntity((BlockEntity)this, (boolean)false);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.growthTime = (Integer)Serializers.INT.fromNBT(tag, "GrowthTime", (Object)0);
        this.doneGrowing = (Boolean)Serializers.BOOLEAN.fromNBT(tag, "DoneGrowing", (Object)false);
        this.prevComparatorLevel = (Integer)Serializers.INT.fromNBT(tag, "PrevComparatorLevel", (Object)0);
        this.comparatorLevel = (Integer)Serializers.INT.fromNBT(tag, "ComparatorLevel", (Object)0);
        this.harvestDelay = (Integer)Serializers.INT.fromNBT(tag, "HarvestDelay", (Object)-1);
        this.exportDelay = (Integer)Serializers.INT.fromNBT(tag, "ExportDelay", (Object)-1);
        this.rngSeed = (Long)Serializers.LONG.fromNBT(tag, "RandomSeed", (Object)Constants.RANDOM.nextLong());
        this.rng.setSeed(this.rngSeed);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        Serializers.INT.toNBT(tag, "GrowthTime", (Object)this.growthTime);
        Serializers.BOOLEAN.toNBT(tag, "DoneGrowing", (Object)this.doneGrowing);
        Serializers.INT.toNBT(tag, "PrevComparatorLevel", (Object)this.prevComparatorLevel);
        Serializers.INT.toNBT(tag, "ComparatorLevel", (Object)this.comparatorLevel);
        Serializers.INT.toNBT(tag, "HarvestDelay", (Object)this.harvestDelay);
        Serializers.INT.toNBT(tag, "ExportDelay", (Object)this.exportDelay);
        Serializers.LONG.toNBT(tag, "RandomSeed", (Object)this.rngSeed);
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public TieredBotanyPotContainer createInventory() {
        return new TieredBotanyPotContainer(this);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("block.botanypotstiers." + this.tier.getName() + "_terracotta_botany_pot");
    }

    public AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new TieredBotanyPotMenu(windowId, (TieredBotanyPotContainer)this.getInventory(), inventory);
    }

    public void addGrowth(int nextIntInclusive) {
        this.growthTime += nextIntInclusive;
        this.markDirty();
    }
}

