/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ultramega.botanypotstiers.TieredBotanyPotHelper;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotContainer;
import com.ultramega.botanypotstiers.data.displaystate.DisplayState;
import com.ultramega.botanypotstiers.data.displaystate.render.DisplayStateRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class TieredBotanyPotRenderer
implements BlockEntityRenderer<TieredBlockEntityBotanyPot> {
    public TieredBotanyPotRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TieredBlockEntityBotanyPot pot, float tickDelta, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        if (pot.getSoil() != null) {
            Level level = pot.m_58904_();
            BlockPos pos = pot.m_58899_();
            int maxGrowth = ((TieredBotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
            float partialOffset = pot.getGrowthTime() < maxGrowth ? tickDelta : 0.0f;
            float growthProgress = Math.max(((float)pot.getGrowthTime() + partialOffset) / (float)maxGrowth, 0.0f);
            pose.m_85836_();
            pose.m_85841_(0.625f, 0.375f, 0.625f);
            pose.m_85837_(0.3, 0.0625, 0.3);
            DisplayStateRenderer.renderState(pot.getSoil().getDisplayState(level, pos, pot), pose, level, pos, bufferSource, light, overlay, growthProgress);
            pose.m_85849_();
            if (pot.getCrop() != null && TieredBotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), pot.getCrop())) {
                pose.m_85836_();
                pose.m_85837_(0.5, 0.40625, 0.5);
                float cropScale = Mth.m_14036_((float)((0.4f + growthProgress * 0.6f) * 0.625f), (float)0.15625f, (float)0.625f);
                pose.m_85841_(cropScale, cropScale, cropScale);
                pose.m_85837_(-0.5, 0.0, -0.5);
                int previousBlocks = 0;
                for (DisplayState state : pot.getCrop().getDisplayState(level, pos, pot)) {
                    if (previousBlocks > 0) {
                        pose.m_85837_(0.0, 1.0, 0.0);
                    }
                    pose.m_85836_();
                    DisplayStateRenderer.renderState(state, pose, pot.m_58904_(), pot.m_58899_(), bufferSource, light, overlay, growthProgress);
                    pose.m_85849_();
                    ++previousBlocks;
                }
                pose.m_85849_();
            }
        }
    }
}

