/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block.inv;

import com.ultramega.botanypotstiers.Constants;
import com.ultramega.botanypotstiers.TieredBotanyPotHelper;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotContainer;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotPotOutput;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TieredBotanyPotMenu
extends AbstractContainerMenu {
    private static final CachedSupplier<MenuType<?>> MENU_TYPE = CachedSupplier.cache(() -> (MenuType)Registry.f_122863_.m_7745_(new ResourceLocation("botanypotstiers", "pot_menu")));
    private final TieredBotanyPotContainer potInv;
    private final Inventory playerInv;

    public static TieredBotanyPotMenu fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        BlockPos tilePos = (BlockPos)Serializers.BLOCK_POS.fromByteBuf(buf);
        BlockEntity blockEntity = inv.f_35978_.f_19853_.m_7702_(tilePos);
        if (blockEntity instanceof TieredBlockEntityBotanyPot) {
            TieredBlockEntityBotanyPot pot = (TieredBlockEntityBotanyPot)blockEntity;
            return new TieredBotanyPotMenu(windowId, (TieredBotanyPotContainer)pot.getInventory(), inv);
        }
        Constants.LOG.error("Attempted to open botany pot at invalid position {}.", (Object)tilePos);
        throw new IllegalStateException("Attempted to open botany pot at invalid position " + tilePos);
    }

    public TieredBotanyPotMenu(int id, TieredBotanyPotContainer potInv, Inventory playerInv) {
        super((MenuType)MENU_TYPE.get(), id);
        this.potInv = potInv;
        this.playerInv = playerInv;
        int slotXOffset = this.isHopper() ? 44 : 80;
        this.m_38897_((Slot)new SlotSoil((Container)potInv, 0, slotXOffset, 48, this.potInv.getPotEntity()::isValidSoil));
        this.m_38897_((Slot)new SlotCropSeed((Container)potInv, 1, slotXOffset, 22, this.potInv.getPotEntity()::isValidSeed));
        if (this.isHopper()) {
            for (int potOutputY = 0; potOutputY < 3; ++potOutputY) {
                for (int potOutputX = 0; potOutputX < 4; ++potOutputX) {
                    int slotId = potOutputX + potOutputY * 4 + 2;
                    int slotX = 80 + potOutputX * 18;
                    int slotY = 17 + potOutputY * 18;
                    this.m_38897_((Slot)new SlotPotOutput((Container)potInv, slotId, slotX, slotY));
                }
            }
        }
        for (int playerInvY = 0; playerInvY < 3; ++playerInvY) {
            for (int playerInvX = 0; playerInvX < 9; ++playerInvX) {
                this.m_38897_(new Slot((Container)playerInv, playerInvX + playerInvY * 9 + 9, 8 + playerInvX * 18, 84 + playerInvY * 18));
            }
        }
        for (int hotbarX = 0; hotbarX < 9; ++hotbarX) {
            this.m_38897_(new Slot((Container)playerInv, hotbarX, 8 + hotbarX * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int slotId) {
        TieredBlockEntityBotanyPot pot = this.potInv.getPotEntity();
        Level level = pot.m_58904_();
        BlockPos pos = pot.m_58899_();
        Slot slot = (Slot)this.f_38839_.get(slotId);
        int firstSlot = this.isHopper() ? 14 : 2;
        int lastSlot = this.isHopper() ? 50 : 38;
        ItemStack unmovedItems = ItemStack.f_41583_;
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            unmovedItems = slotStack.m_41777_();
            if (this.isHopper() && slotId >= 2 && slotId <= 13) {
                if (!this.m_38903_(slotStack, firstSlot, lastSlot, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, unmovedItems);
            } else if (slotId == 0 || slotId == 1) {
                if (!this.m_38903_(slotStack, firstSlot, lastSlot, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotId >= firstSlot && slotId <= lastSlot) {
                Slot cropSlot;
                Slot soilSlot = (Slot)this.f_38839_.get(0);
                if (!soilSlot.m_6657_() && TieredBotanyPotHelper.findSoil(level, pos, pot, slotStack) != null) {
                    soilSlot.m_5852_(slotStack.m_41620_(1));
                    slot.m_5852_(slotStack);
                    if (slotStack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                }
                if (!(cropSlot = (Slot)this.f_38839_.get(1)).m_6657_() && TieredBotanyPotHelper.findCrop(level, pos, pot, slotStack) != null) {
                    cropSlot.m_5852_(slotStack.m_41620_(1));
                    slot.m_5852_(slotStack);
                    if (slotStack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == unmovedItems.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return unmovedItems;
    }

    public boolean isHopper() {
        return this.potInv.getPotEntity().isHopper();
    }

    public boolean m_6875_(Player player) {
        return this.potInv.m_6542_(player);
    }

    public TieredBotanyPotContainer getPotInventory() {
        return this.potInv;
    }
}

