/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block.inv;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ultramega.botanypotstiers.TieredBotanyPotHelper;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotMenu;
import com.ultramega.botanypotstiers.data.recipes.crop.Crop;
import com.ultramega.botanypotstiers.data.recipes.soil.Soil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TieredBotanyPotScreen
extends AbstractContainerScreen<TieredBotanyPotMenu> {
    private static final NumberFormat MULTIPLIER_FORMAT = new DecimalFormat("##.##");
    private static final Component NEW_LINE = new TextComponent("");
    private static final Component TOOLTIP_INVALID_SOIL = new TranslatableComponent("tooltip.botanypots.invalid_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INVALID_CROP = new TranslatableComponent("tooltip.botanypots.invalid_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SOIL = new TranslatableComponent("tooltip.botanypots.incorrect_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SEED = new TranslatableComponent("tooltip.botanypots.incorrect_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SOIL = new TranslatableComponent("tooltip.botanypots.missing_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SEED = new TranslatableComponent("tooltip.botanypots.missing_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_SOIL_ITEM = new TranslatableComponent("tooltip.botanypots.soil_item").m_130940_(ChatFormatting.GREEN);
    private static final Component TOOLTIP_SEED_ITEM = new TranslatableComponent("tooltip.botanypots.seed_item").m_130940_(ChatFormatting.GREEN);
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private final ResourceLocation backgroundTexture;

    public TieredBotanyPotScreen(TieredBotanyPotMenu menu, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)menu, playerInv, name);
        this.backgroundTexture = new ResourceLocation("botanypotstiers", "textures/gui/container/" + (menu.isHopper() ? "hopper_botany_pot_gui.png" : "botany_pot_gui.png"));
    }

    public void m_7856_() {
        super.m_7856_();
        int recipeOffset = this.f_97735_ + (((TieredBotanyPotMenu)this.f_97732_).isHopper() ? 13 : 33);
        this.m_142416_((GuiEventListener)new ImageButton(recipeOffset, this.f_96544_ / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, btn -> {}));
    }

    protected void m_7286_(PoseStack poseStack, float v, int i, int i1) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.backgroundTexture);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float tickDelta) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, tickDelta);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    public List<Component> m_96555_(ItemStack stack) {
        List tooltips = super.m_96555_(stack);
        if (this.f_96541_ != null) {
            boolean isAdvanced = this.f_96541_.f_91066_.f_92125_;
            LocalPlayer player = this.f_96541_.f_91074_;
            TieredBlockEntityBotanyPot pot = ((TieredBotanyPotMenu)this.f_97732_).getPotInventory().getPotEntity();
            Level level = pot.m_58904_();
            BlockPos pos = pot.m_58899_();
            Slot slot = this.f_97734_;
            if (slot instanceof SlotSoil) {
                SlotSoil soilSlot = (SlotSoil)slot;
                if (!pot.isValidSoil(stack)) {
                    tooltips.add(TOOLTIP_INVALID_SOIL);
                } else {
                    soil = TieredBotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (soil != null) {
                        if (pot.getCrop() == null) {
                            tooltips.add(TOOLTIP_MISSING_SEED);
                        } else if (!TieredBotanyPotHelper.canCropGrow(level, pos, pot, (Soil)((Object)soil), pot.getCrop())) {
                            tooltips.add(TOOLTIP_INCORRECT_SOIL);
                        } else {
                            float growthModifier = soil.getGrowthModifier(level, pos, pot, pot.getCrop());
                            MutableComponent multiplier = new TextComponent(MULTIPLIER_FORMAT.format(growthModifier)).m_130940_(growthModifier > 1.0f ? ChatFormatting.GREEN : (growthModifier < 1.0f ? ChatFormatting.RED : ChatFormatting.GRAY));
                            tooltips.add(new TranslatableComponent("tooltip.botanypots.soil_modifier", new Object[]{multiplier}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
            } else {
                soil = this.f_97734_;
                if (soil instanceof SlotCropSeed) {
                    Crop crop;
                    SlotCropSeed seedSlot = (SlotCropSeed)soil;
                    if (!pot.isValidSeed(stack)) {
                        tooltips.add(TOOLTIP_INVALID_CROP);
                    }
                    if ((crop = TieredBotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        if (pot.getSoil() == null) {
                            tooltips.add(TOOLTIP_MISSING_SOIL);
                        } else if (!TieredBotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), crop)) {
                            tooltips.add(TOOLTIP_INCORRECT_SEED);
                        }
                    }
                } else {
                    Crop hoveredCrop;
                    Soil hoverSoil = TieredBotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (hoverSoil != null) {
                        tooltips.add(TOOLTIP_SOIL_ITEM);
                        if (isAdvanced) {
                            tooltips.add(new TranslatableComponent("tooltip.botanypots.soil_id", new Object[]{hoverSoil.m_6423_().toString()}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                    if ((hoveredCrop = TieredBotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        tooltips.add(TOOLTIP_SEED_ITEM);
                        if (isAdvanced) {
                            tooltips.add(new TranslatableComponent("tooltip.botanypots.crop_id", new Object[]{hoveredCrop.m_6423_().toString()}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
            }
        }
        return tooltips;
    }
}

