/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.data.displaystate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ultramega.botanypotstiers.data.displaystate.DisplayState;
import com.ultramega.botanypotstiers.data.displaystate.DisplayStateSerializer;
import com.ultramega.botanypotstiers.data.displaystate.SimpleDisplayState;
import com.ultramega.botanypotstiers.data.displaystate.TransitionalDisplayState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AgingDisplayState
extends TransitionalDisplayState {
    public static final ResourceLocation ID = new ResourceLocation("botanypotstiers", "aging");
    public static final DisplayStateSerializer<AgingDisplayState> SERIALIZER = new Serializer();
    private final BlockState defaultState;

    public AgingDisplayState(BlockState defaultState) {
        super(AgingDisplayState.calculatePhases(defaultState));
        this.defaultState = defaultState;
    }

    @Override
    public DisplayStateSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static IntegerProperty getAgeProperty(Block block) {
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.m_7959_();
        }
        Property ageProperty = block.m_49965_().m_61081_("age");
        if (ageProperty instanceof IntegerProperty) {
            IntegerProperty intProp = (IntegerProperty)ageProperty;
            return intProp;
        }
        return null;
    }

    private static List<DisplayState> calculatePhases(BlockState defaultState) {
        Block block = defaultState.m_60734_();
        ArrayList<DisplayState> phases = new ArrayList<DisplayState>();
        IntegerProperty ageProp = AgingDisplayState.getAgeProperty(block);
        if (ageProp != null) {
            Iterator iterator = ageProp.m_6908_().iterator();
            while (iterator.hasNext()) {
                int age = (Integer)iterator.next();
                phases.add(new SimpleDisplayState((BlockState)defaultState.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(age))));
            }
        } else {
            phases.add(new SimpleDisplayState(defaultState));
        }
        return phases;
    }

    public static class Serializer
    implements DisplayStateSerializer<AgingDisplayState> {
        @Override
        public ResourceLocation getId() {
            return ID;
        }

        public AgingDisplayState fromJSON(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject obj = (JsonObject)json;
                BlockState defaultState = (BlockState)Serializers.BLOCK_STATE.fromJSON(obj, "block");
                if (defaultState == null) {
                    throw new JsonParseException("Could not read block! " + obj.get("block"));
                }
                return new AgingDisplayState(defaultState);
            }
            throw new JsonParseException("Expected AgingDisplayState to be a JSON object.");
        }

        public JsonElement toJSON(AgingDisplayState toWrite) {
            JsonObject json = new JsonObject();
            Serializers.BLOCK_STATE.toJSON(json, "block", (Object)toWrite.defaultState);
            return json;
        }

        public AgingDisplayState fromByteBuf(FriendlyByteBuf buffer) {
            BlockState block = (BlockState)Serializers.BLOCK_STATE.fromByteBuf(buffer);
            return new AgingDisplayState(block);
        }

        public void toByteBuf(FriendlyByteBuf buffer, AgingDisplayState toWrite) {
            Serializers.BLOCK_STATE.toByteBuf(buffer, (Object)toWrite.defaultState);
        }

        public Tag toNBT(AgingDisplayState toWrite) {
            return null;
        }

        public AgingDisplayState fromNBT(Tag nbt) {
            return null;
        }
    }
}

