/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.data.recipes.potinteraction;

import com.ultramega.botanypotstiers.TieredBotanyPotHelper;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import com.ultramega.botanypotstiers.block.inv.TieredBotanyPotContainer;
import com.ultramega.botanypotstiers.data.recipes.potinteraction.PotInteraction;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BasicPotInteraction
extends PotInteraction {
    protected final Ingredient heldTest;
    protected final boolean damageHeld;
    @Nullable
    protected final Ingredient soilTest;
    @Nullable
    protected final Ingredient seedTest;
    @Nullable
    protected final ItemStack newSoilStack;
    @Nullable
    protected final ItemStack newSeedStack;
    @Nullable
    protected final Sound sound;
    protected final List<ItemStack> extraDrops;

    public BasicPotInteraction(ResourceLocation id, Ingredient heldTest, boolean damageHeld, @Nullable Ingredient soilTest, @Nullable Ingredient seedTest, @Nullable ItemStack newSoilStack, @Nullable ItemStack newSeedStack, @Nullable Sound sound, List<ItemStack> extraDrops) {
        super(id);
        this.heldTest = heldTest;
        this.damageHeld = damageHeld;
        this.soilTest = soilTest;
        this.seedTest = seedTest;
        this.newSoilStack = newSoilStack;
        this.newSeedStack = newSeedStack;
        this.sound = sound;
        this.extraDrops = extraDrops;
    }

    @Override
    public boolean canApply(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, TieredBlockEntityBotanyPot pot) {
        return !(!this.heldTest.test(heldStack) || this.soilTest != null && !this.soilTest.test(((TieredBotanyPotContainer)pot.getInventory()).getSoilStack()) || this.seedTest != null && !this.seedTest.test(((TieredBotanyPotContainer)pot.getInventory()).getCropStack()));
    }

    @Override
    public void apply(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, TieredBlockEntityBotanyPot pot) {
        if (!world.f_46443_) {
            ItemStack dropStack;
            if (this.newSoilStack != null) {
                if (Services.INVENTORY_HELPER.hasCraftingRemainder(((TieredBotanyPotContainer)pot.getInventory()).getSoilStack()) && (dropStack = Services.INVENTORY_HELPER.getCraftingRemainder(((TieredBotanyPotContainer)pot.getInventory()).getSoilStack())) != null) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack.m_41777_());
                }
                ((TieredBotanyPotContainer)pot.getInventory()).m_6836_(0, this.newSoilStack.m_41777_());
            }
            if (this.newSeedStack != null) {
                if (Services.INVENTORY_HELPER.hasCraftingRemainder(((TieredBotanyPotContainer)pot.getInventory()).getCropStack()) && (dropStack = Services.INVENTORY_HELPER.getCraftingRemainder(((TieredBotanyPotContainer)pot.getInventory()).getCropStack())) != null) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack.m_41777_());
                }
                ((TieredBotanyPotContainer)pot.getInventory()).m_6836_(1, this.newSeedStack.m_41777_());
            }
            if (this.damageHeld && heldStack.m_41776_() > 0) {
                Services.INVENTORY_HELPER.damageStack(heldStack, 1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            } else {
                ItemStack remainder = Services.INVENTORY_HELPER.getCraftingRemainder(heldStack);
                if (!remainder.m_41619_()) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)remainder.m_41777_());
                }
                heldStack.m_41774_(1);
            }
            if (this.extraDrops != null && !this.extraDrops.isEmpty()) {
                for (ItemStack drop : this.extraDrops) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop.m_41777_());
                }
            }
        }
        if (this.sound != null) {
            this.sound.playSoundAt(world, player, pos);
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TieredBotanyPotHelper.SIMPLE_POT_INTERACTION_SERIALIZER.get();
    }
}

