/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.data.recipes.soil;

import com.ultramega.botanypotstiers.TieredBotanyPotHelper;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import com.ultramega.botanypotstiers.data.displaystate.DisplayState;
import com.ultramega.botanypotstiers.data.recipes.crop.Crop;
import com.ultramega.botanypotstiers.data.recipes.soil.Soil;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BasicSoil
extends Soil {
    protected Ingredient ingredient;
    protected DisplayState displayState;
    protected float growthModifier;
    protected Set<String> categories;
    protected int lightLevel;

    public BasicSoil(ResourceLocation id, Ingredient ingredient, DisplayState renderState, float growthModifier, Set<String> categories, int lightLevel) {
        super(id);
        this.ingredient = ingredient;
        this.displayState = renderState;
        this.growthModifier = growthModifier;
        this.categories = categories;
        this.lightLevel = lightLevel;
    }

    @Override
    public boolean matchesLookup(Level level, BlockPos pos, TieredBlockEntityBotanyPot pot, ItemStack placedStack) {
        return this.ingredient.test(placedStack);
    }

    @Override
    public float getGrowthModifier(Level level, BlockPos pos, TieredBlockEntityBotanyPot pot, @Nullable Crop crop) {
        return this.growthModifier;
    }

    @Override
    public int getLightLevel(Level level, BlockPos pos, TieredBlockEntityBotanyPot pot) {
        return this.lightLevel;
    }

    @Override
    public boolean canGrowCrop(Level level, BlockPos pos, TieredBlockEntityBotanyPot pot, Crop crop) {
        for (String soilCategory : this.getCategories(level, pos, pot)) {
            for (String cropCategory : crop.getCategories(level, pos, pot)) {
                if (!soilCategory.equalsIgnoreCase(cropCategory)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getCategories(Level level, BlockPos pos, TieredBlockEntityBotanyPot pot) {
        return this.categories;
    }

    @Override
    public DisplayState getDisplayState(Level level, BlockPos pos, TieredBlockEntityBotanyPot pot) {
        return this.displayState;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)TieredBotanyPotHelper.SOIL_TYPE.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TieredBotanyPotHelper.SOIL_SERIALIZER.get();
    }
}

