/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.modules.CompatModule;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SimpleModule
extends CompatModule {
    private final String shortId;
    private final Map<String, EntrySet<?, ?>> entries = new LinkedHashMap();

    public SimpleModule(String modId, String shortId) {
        super(modId);
        this.shortId = shortId;
    }

    public void addEntry(EntrySet<?, ?> entryHolder) {
        this.entries.put(entryHolder.getName(), entryHolder);
    }

    public Collection<EntrySet<?, ?>> getEntries() {
        return this.entries.values();
    }

    public EntrySet<?, ?> getEntry(String name) {
        EntrySet<?, ?> e = this.entries.get(name);
        if (e == null) {
            throw new UnsupportedOperationException(String.format("This module does not have entries of type %s", name));
        }
        return e;
    }

    @Override
    public String shortenedId() {
        return this.shortId;
    }

    @Override
    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
        this.getEntries().forEach(e -> e.addTranslations(this, lang));
    }

    @Override
    public void registerWoodBlocks(IForgeRegistry<Block> registry, Collection<WoodType> woodTypes) {
        this.getEntries().forEach(e -> e.registerWoodBlocks(this, registry, woodTypes));
    }

    @Override
    public void registerLeavesBlocks(IForgeRegistry<Block> registry, Collection<LeavesType> leavesTypes) {
        this.getEntries().forEach(e -> e.registerLeavesBlocks(this, registry, leavesTypes));
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        this.getEntries().forEach(e -> e.registerItems(this, registry));
    }

    @Override
    public void registerTiles(IForgeRegistry<BlockEntityType<?>> registry) {
        this.getEntries().forEach(e -> e.registerTiles(this, registry));
    }

    @Override
    public void addStaticServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> e.generateTags(this, (DynamicDataPack)handler.dynamicPack, manager));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> {
            e.generateLootTables(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateRecipes(this, (DynamicDataPack)handler.dynamicPack, manager);
        });
    }

    @Override
    public void addStaticClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> e.generateModels(this, (DynamicTexturePack)handler.dynamicPack, manager));
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> e.generateTextures(this, handler, manager));
    }

    @Override
    public void onClientSetup() {
        this.getEntries().forEach(EntrySet::setRenderLayer);
    }

    @Override
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        this.getEntries().forEach(e -> e.registerEntityRenderers(this, event));
    }
}

