/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.client.asset_generators.LangBuilder;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Respriter;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.mehvahdjukaar.selene.resourcepack.RPAwareDynamicTextureProvider;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class CompatModule {
    protected final String modId;

    public CompatModule(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public abstract String shortenedId();

    public String toString() {
        return "EveryCompat " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public ResourceLocation modRes(String string) {
        return new ResourceLocation(this.modId, string);
    }

    public List<String> getAlreadySupportedMods() {
        return List.of();
    }

    @Deprecated(forRemoval=true)
    public String makeBlockId(BlockType type, String blockName) {
        return this.shortenedId() + "/" + type.getVariantId(blockName, false);
    }

    public void onModSetup() {
    }

    public void onClientSetup() {
    }

    public void registerWoodBlocks(IForgeRegistry<Block> registry, Collection<WoodType> woodTypes) {
    }

    public void registerLeavesBlocks(IForgeRegistry<Block> registry, Collection<LeavesType> leavesTypes) {
    }

    public void registerItems(IForgeRegistry<Item> registry) {
    }

    public void registerTiles(IForgeRegistry<BlockEntityType<?>> registry) {
    }

    public void registerEntities(IForgeRegistry<EntityType<?>> registry) {
    }

    public final boolean isEntryAlreadyRegistered(String name, BlockType woodType, IForgeRegistry<?> registry) {
        name = name.substring(name.lastIndexOf("/") + 1);
        String woodFrom = woodType.getNamespace();
        if (this.getAlreadySupportedMods().contains(woodFrom)) {
            return true;
        }
        if (woodFrom.equals("tfc")) {
            return false;
        }
        if (woodFrom.equals(this.modId)) {
            return true;
        }
        String n1 = woodFrom + "/" + name;
        String n2 = woodFrom + "_" + name;
        if (registry.containsKey(new ResourceLocation(this.modId, name)) || registry.containsKey(new ResourceLocation(this.modId, n2))) {
            return true;
        }
        if (this.shortenedId().equals("af")) {
            return false;
        }
        if (this.shortenedId().equals("vs")) {
            return false;
        }
        if (registry.containsKey(new ResourceLocation(woodFrom, name))) {
            return true;
        }
        for (WoodGood.CompatMod c : WoodGood.COMPAT_MODS) {
            String compatModId = c.modId();
            if (!woodFrom.equals(c.woodFrom()) || !c.blocksFrom().contains(this.modId)) continue;
            if (registry.containsKey(new ResourceLocation(compatModId, name))) {
                return true;
            }
            if (registry.containsKey(new ResourceLocation(compatModId, n2))) {
                return true;
            }
            if (!registry.containsKey(new ResourceLocation(compatModId, n2))) continue;
            return true;
        }
        return false;
    }

    public void addStaticServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
    }

    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
    }

    public void addStaticClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
    }

    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
    }

    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
    }

    public void registerColors(ColorHandlerEvent.Item event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
    }

    protected final <T extends Block> T getModBlock(String id, Class<T> blockClass) {
        return (T)((Block)ForgeRegistries.BLOCKS.getValue(this.modRes(id)));
    }

    protected final Block getModBlock(String id) {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.modRes(id));
    }

    protected final void addChildToOak(String category, String oakBlockName) {
        WoodType.OAK_WOOD_TYPE.addChild(category, (ItemLike)ForgeRegistries.BLOCKS.getValue(this.modRes(oakBlockName)));
    }

    public void addWoodTexture(WoodType wood, RPAwareDynamicTextureProvider handler, ResourceManager manager, String path, Supplier<TextureImage> textureSupplier) {
        handler.addTextureIfNotPresent(manager, path, () -> {
            TextureImage t = (TextureImage)textureSupplier.get();
            this.maybeFlowerAzalea(t, manager, wood);
            return t;
        });
    }

    protected void maybeFlowerAzalea(TextureImage image, ResourceManager manager, WoodType woodType) {
        WoodType azalea;
        if (woodType.getId().toString().equals("ecologics:flowering_azalea") && (azalea = (WoodType)WoodTypeRegistry.WOOD_TYPES.get(new ResourceLocation("ecologics:azalea"))) != null) {
            try (TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)azalea.planks));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, mask});
                temp.close();
            }
            catch (Exception e) {
                WoodGood.LOGGER.warn("failed to apply azalea overlay: ", (Throwable)e);
            }
        }
    }

    public <T extends BlockType, B extends Block> Function<T, @Nullable B> ifHasChild(Function<T, B> supplier, String ... children) {
        return w -> {
            for (String v : children) {
                if (w.getChild(v) != null) continue;
                return null;
            }
            return (Block)supplier.apply(w);
        };
    }

    public void onFirstClientTick() {
    }
}

