/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.corail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.minecraft.core.Registry;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import ovh.corail.corail_pillar.block.BlockPillar;
import ovh.corail.corail_pillar.registry.ModTabs;

public class PillarModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> LOG_PILLAR;
    public final SimpleEntrySet<WoodType, Block> SMALL_LOG_PILLAR;
    public final SimpleEntrySet<WoodType, Block> PLANK_PILLAR;
    public final SimpleEntrySet<WoodType, Block> SMALL_PLANK_PILLAR;

    public PillarModule(String modId) {
        super(modId, "cpr");
        CreativeModeTab tab = ModTabs.mainTab;
        this.LOG_PILLAR = SimpleEntrySet.builder(WoodType.class, "log", "pillar", () -> this.getModBlock("pillar_oak_log"), () -> WoodType.OAK_WOOD_TYPE, w -> new BlockPillar(w.getTypeName(), w.log, false)).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("pillar"), Registry.f_122901_).addTag(this.modRes("wooden_pillar"), Registry.f_122901_).setTab(() -> tab).build();
        this.addEntry(this.LOG_PILLAR);
        this.SMALL_LOG_PILLAR = SimpleEntrySet.builder(WoodType.class, "log", "small_pillar", () -> this.getModBlock("small_pillar_oak_log"), () -> WoodType.OAK_WOOD_TYPE, w -> new BlockPillar(w.getTypeName(), w.log, true)).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("pillar"), Registry.f_122901_).addTag(this.modRes("wooden_pillar"), Registry.f_122901_).setTab(() -> tab).build();
        this.addEntry(this.SMALL_LOG_PILLAR);
        this.PLANK_PILLAR = SimpleEntrySet.builder(WoodType.class, "planks", "pillar", () -> this.getModBlock("pillar_oak_planks"), () -> WoodType.OAK_WOOD_TYPE, w -> new BlockPillar(w.getTypeName(), w.log, true)).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("pillar"), Registry.f_122901_).addTag(this.modRes("wooden_pillar"), Registry.f_122901_).setTab(() -> tab).build();
        this.addEntry(this.PLANK_PILLAR);
        this.SMALL_PLANK_PILLAR = SimpleEntrySet.builder(WoodType.class, "planks", "small_pillar", () -> this.getModBlock("small_pillar_oak_planks"), () -> WoodType.OAK_WOOD_TYPE, w -> new BlockPillar(w.getTypeName(), w.log, true)).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("pillar"), Registry.f_122901_).addTag(this.modRes("wooden_pillar"), Registry.f_122901_).setTab(() -> tab).build();
        this.addEntry(this.SMALL_PLANK_PILLAR);
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        this.LOG_PILLAR.items.forEach((wood, item) -> {
            this.woodcuttingRecipe(handler, (WoodType)wood, wood.log.m_5456_(), (Item)item, 2);
            this.PILLAR_from_small_pillar(handler, (WoodType)wood, (Item)this.SMALL_LOG_PILLAR.items.get(wood), (Item)item);
            this.woodcuttingRecipe(handler, (WoodType)wood, wood.log.m_5456_(), (Item)this.SMALL_LOG_PILLAR.items.get(wood), 4, true);
            this.SMALL_PILLAR_from_woods(handler, (WoodType)wood, wood.log.m_5456_(), (Item)this.SMALL_LOG_PILLAR.items.get(wood));
            this.SMALL_PILLAR_from_pillar(handler, (WoodType)wood, (Item)item, (Item)this.SMALL_LOG_PILLAR.items.get(wood));
            this.woodcuttingRecipe(handler, (WoodType)wood, wood.planks.m_5456_(), (Item)this.PLANK_PILLAR.items.get(wood), 2);
            this.PILLAR_from_small_pillar(handler, (WoodType)wood, (Item)this.SMALL_PLANK_PILLAR.items.get(wood), (Item)this.PLANK_PILLAR.items.get(wood));
            this.woodcuttingRecipe(handler, (WoodType)wood, wood.planks.m_5456_(), (Item)this.SMALL_PLANK_PILLAR.items.get(wood), 4, true);
            this.SMALL_PILLAR_from_woods(handler, (WoodType)wood, wood.planks.m_5456_(), (Item)this.SMALL_PLANK_PILLAR.items.get(wood));
            this.SMALL_PILLAR_from_pillar(handler, (WoodType)wood, (Item)this.PLANK_PILLAR.items.get(wood), (Item)this.SMALL_PLANK_PILLAR.items.get(wood));
        });
    }

    public void woodcuttingRecipe(ServerDynamicResourcesHandler handler, WoodType wood, Item input, Item output, int count, boolean isSmall) {
        String filenameBuilder = "pillar_" + input.toString();
        if (isSmall) {
            filenameBuilder = "small_" + filenameBuilder;
        }
        JsonObject insideCondition = new JsonObject();
        insideCondition.addProperty("type", "forge:mod_loaded");
        insideCondition.addProperty("modid", "corail_woodcutter");
        JsonArray condition = new JsonArray();
        condition.add((JsonElement)insideCondition);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", Objects.requireNonNull(input.getRegistryName()).toString());
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "corail_woodcutter:woodcutting");
        recipe.add("ingredient", (JsonElement)ingredient);
        recipe.addProperty("result", Objects.requireNonNull(output.getRegistryName()).toString());
        recipe.addProperty("count", (Number)count);
        recipe.add("condition", (JsonElement)condition);
        ((DynamicDataPack)handler.dynamicPack).addJson(WoodGood.res("cpr/" + wood.getNamespace() + "/woodcutting/" + filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
    }

    public void woodcuttingRecipe(ServerDynamicResourcesHandler handler, WoodType wood, Item input, Item output, int count) {
        this.woodcuttingRecipe(handler, wood, input, output, count, false);
    }

    public void SMALL_PILLAR_from_woods(ServerDynamicResourcesHandler handler, WoodType wood, Item input, Item output) {
        Object filenameBuilder = "pillar_wood/";
        filenameBuilder = input == wood.log.m_5456_() ? (String)filenameBuilder + "log/" : (String)filenameBuilder + "planks/";
        filenameBuilder = (String)filenameBuilder + wood.getTypeName();
        JsonObject result = new JsonObject();
        result.addProperty("item", Objects.requireNonNull(output.getRegistryName()).toString());
        result.addProperty("count", (Number)6);
        JsonObject clay = new JsonObject();
        clay.addProperty("item", "minecraft:clay_ball");
        JsonObject log = new JsonObject();
        log.addProperty("item", Objects.requireNonNull(input.getRegistryName()).toString());
        JsonObject key = new JsonObject();
        key.add("0", (JsonElement)clay);
        key.add("1", (JsonElement)log);
        JsonArray pattern = new JsonArray();
        pattern.add(" 1 ");
        pattern.add(" 0 ");
        pattern.add(" 1 ");
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "minecraft:crafting_shaped");
        recipe.add("pattern", (JsonElement)pattern);
        recipe.add("key", (JsonElement)key);
        recipe.add("result", (JsonElement)result);
        ((DynamicDataPack)handler.dynamicPack).addJson(WoodGood.res("cpr/" + wood.getNamespace() + "/woodcutting/" + (String)filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
    }

    public void SMALL_PILLAR_from_pillar(ServerDynamicResourcesHandler handler, WoodType wood, Item input, Item output) {
        Object filenameBuilder = "small_pillar_wood/";
        filenameBuilder = input == wood.log.m_5456_() || input == this.LOG_PILLAR.items.get(wood) ? (String)filenameBuilder + "log/" : (String)filenameBuilder + "planks/";
        filenameBuilder = (String)filenameBuilder + wood.getTypeName();
        JsonObject result = new JsonObject();
        result.addProperty("item", Objects.requireNonNull(output.getRegistryName()).toString());
        result.addProperty("count", (Number)2);
        JsonObject insideIngredient = new JsonObject();
        insideIngredient.addProperty("item", Objects.requireNonNull(input.getRegistryName()).toString());
        JsonArray ingredients = new JsonArray();
        ingredients.add((JsonElement)insideIngredient);
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "minecraft:crafting_shapeless");
        recipe.add("ingredients", (JsonElement)ingredients);
        recipe.add("result", (JsonElement)result);
        ((DynamicDataPack)handler.dynamicPack).addJson(WoodGood.res("cpr/" + wood.getNamespace() + "/woodcutting/" + (String)filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
    }

    public void PILLAR_from_small_pillar(ServerDynamicResourcesHandler handler, WoodType wood, Item input, Item output) {
        String filenameBuilder = wood.getTypeName() + "pillar_to_small_pillar";
        filenameBuilder = input == wood.log.m_5456_() || input == this.SMALL_LOG_PILLAR.items.get(wood) ? filenameBuilder + "_log" : filenameBuilder + "_planks";
        JsonObject result = new JsonObject();
        result.addProperty("item", Objects.requireNonNull(output.getRegistryName()).toString());
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", Objects.requireNonNull(input.getRegistryName()).toString());
        JsonObject key = new JsonObject();
        key.add("0", (JsonElement)ingredient);
        JsonArray pattern = new JsonArray();
        pattern.add("00");
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "minecraft:crafting_shaped");
        recipe.add("pattern", (JsonElement)pattern);
        recipe.add("key", (JsonElement)key);
        recipe.add("result", (JsonElement)result);
        ((DynamicDataPack)handler.dynamicPack).addJson(WoodGood.res("cpr/" + wood.getNamespace() + "/woodcutting/" + filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
    }
}

