/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.corail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.item.WoodcutterItem;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModStats;
import ovh.corail.woodcutter.registry.ModTabs;

public class WoodcutterModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> WOODCUTTER = SimpleEntrySet.builder(WoodType.class, "woodcutter", () -> this.getModBlock("oak_woodcutter"), () -> WoodType.OAK_WOOD_TYPE, w -> new CompatWoodcutterBlock()).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("woodcutters"), Registry.f_122901_).addTag(this.modRes("vanilla_woodcutters"), Registry.f_122901_).addTag(this.modRes("woodcutters"), Registry.f_122904_).addTag(this.modRes("vanilla_woodcutters"), Registry.f_122904_).addCustomItem((TriFunction<WoodType, Block, Item.Properties, Item>)((TriFunction)(w, b, p) -> new WoodcutterItem(b))).setTab(() -> ModTabs.mainTab).setRenderType(() -> RenderType::m_110463_).build();

    public WoodcutterModule(String modId) {
        super(modId, "cwr");
        this.addEntry(this.WOODCUTTER);
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        this.WOODCUTTER.items.forEach((wood, item) -> {
            this.woodcutterRecipe(handler, wood.planks, (Item)item, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "button", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "button", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "door", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "door", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "fence", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "fence", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "fence_gate", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "planks", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "boat", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "pressure_plate", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "pressure_plate", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "sign", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "sign", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "slab", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "slab", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "stairs", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "stairs", 1, (WoodType)wood);
            this.woodcuttingRecipe(handler, "logs", "trapdoor", 4, (WoodType)wood);
            this.woodcuttingRecipe(handler, "planks", "trapdoor", 1, (WoodType)wood);
        });
    }

    public void woodcutterRecipe(ServerDynamicResourcesHandler handler, Block input, Item output, WoodType wood) {
        JsonArray pattern = new JsonArray();
        pattern.add(" 1 ");
        pattern.add("000");
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", Objects.requireNonNull(input.getRegistryName()).toString());
        JsonObject tag = new JsonObject();
        if (wood.getNamespace().equals("tfc") || wood.getNamespace().equals("afc")) {
            tag.addProperty("tag", "forge:ingots/wrought_iron");
        } else {
            tag.addProperty("tag", "forge:ingots/iron");
        }
        JsonObject key = new JsonObject();
        key.add("0", (JsonElement)ingredient);
        key.add("1", (JsonElement)tag);
        JsonObject result = new JsonObject();
        result.addProperty("item", Objects.requireNonNull(output.getRegistryName()).toString());
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "minecraft:crafting_shaped");
        recipe.addProperty("group", "woodcutter");
        recipe.add("pattern", (JsonElement)pattern);
        recipe.add("key", (JsonElement)key);
        recipe.add("result", (JsonElement)result);
        ((DynamicDataPack)handler.dynamicPack).addJson(WoodGood.res("cwr/" + wood.getAppendableId() + "_woodcutter"), (JsonElement)recipe, ResType.RECIPES);
    }

    public void woodcuttingRecipe(ServerDynamicResourcesHandler handler, String input, String output, int count, WoodType wood) {
        if (wood.getItemOfThis(output) != null) {
            String blockType = wood.getTypeName() + "_" + input;
            JsonObject ingredient = new JsonObject();
            if (Objects.equals(input, "logs")) {
                ingredient.addProperty("tag", wood.getNamespace() + ":" + blockType);
            } else {
                ingredient.addProperty("item", Objects.requireNonNull(wood.planks.getRegistryName()).toString());
            }
            JsonObject recipe = new JsonObject();
            recipe.addProperty("type", "corail_woodcutter:woodcutting");
            recipe.add("ingredient", (JsonElement)ingredient);
            recipe.addProperty("result", String.valueOf(Objects.requireNonNull(wood.getItemOfThis(output)).getRegistryName()));
            recipe.addProperty("count", (Number)count);
            WoodGood.LOGGER.info("<recipe> RUNNING - JSON:" + recipe);
            String filenameBuilder = wood.getTypeName() + "_" + output + "_from_" + blockType;
            ((DynamicDataPack)handler.dynamicPack).addJson(WoodGood.res("cwr/" + wood.getNamespace() + "/woodcutting/" + filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
        }
    }

    @Override
    public void onModSetup() {
        ModBlocks.WOODCUTTERS.addAll((Collection)((Object)this.WOODCUTTER.blocks));
    }

    @Override
    public List<String> getAlreadySupportedMods() {
        return List.of("biomesoplenty", "twilightforest", "tropicraft", "corail_woodcutter_extension_byg", "quark");
    }

    public class CompatWoodcutterBlock
    extends WoodcutterBlock {
        public CompatWoodcutterBlock() {
            this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }

        @NotNull
        public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
            if (!worldIn.m_5776_()) {
                player.m_5893_(state.m_60750_(worldIn, pos));
                player.m_36220_(ModStats.INTERACT_WITH_SAWMILL);
            }
            return InteractionResult.CONSUME;
        }

        @Nullable
        public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
            return new SimpleMenuProvider((id, playerInventory, player) -> new WoodcutterContainer(id, playerInventory, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), (Component)TRANSLATION);
        }
    }
}

