/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.iron_age_furniture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcmoddev.ironagefurniture.api.Blocks.Chair;
import com.mcmoddev.ironagefurniture.api.Enumerations.BenchType;
import com.mcmoddev.ironagefurniture.api.Enumerations.Rotation;
import com.mcmoddev.ironagefurniture.api.properties.BenchTypeProperty;
import com.mcmoddev.ironagefurniture.api.util.Swivel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CompatBackBench
extends Chair {
    public static final BenchTypeProperty TYPE = BenchTypeProperty.create((String)"type", (BenchType[])new BenchType[]{BenchType.SINGLE, BenchType.LEFT, BenchType.MIDDLE, BenchType.RIGHT});

    public CompatBackBench(float hardness, float blastResistance, SoundType sound, String name) {
        super(hardness, blastResistance, sound, name);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    protected void generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            BenchType type = (BenchType)state.m_61143_((Property)TYPE);
            VoxelShape shapes = Shapes.m_83040_();
            shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)7.0, (double)15.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
            shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
            switch (type) {
                case SINGLE: {
                    shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)10.0, (double)12.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
                    shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)12.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case LEFT: {
                    shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)10.0, (double)12.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case RIGHT: {
                    shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)12.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
                }
            }
            shapes = Shapes.m_83148_((VoxelShape)shapes, (VoxelShape)CompatBackBench.getShapes((VoxelShape)CompatBackBench.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)7.0, (double)16.0, (double)4.0, (double)9.0), (Direction)Direction.SOUTH))[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()], (BooleanOp)BooleanOp.f_82695_);
            builder.put((Object)state, (Object)shapes.m_83296_());
        }
        this._shapes = builder.build();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockStateToJoinTo;
        Direction benchAxis;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState stateForPlacement = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_))).m_61124_((Property)DIRECTION, (Comparable)context.m_8125_())).m_61124_((Property)TYPE, (Comparable)BenchType.SINGLE);
        if (!context.m_43723_().m_6144_() && (benchAxis = this.getBenchToJoinTo(context.m_8125_(), world, pos)) != null && (blockStateToJoinTo = world.m_8055_(pos.m_142300_(benchAxis))).m_60734_().getRegistryName().equals((Object)stateForPlacement.m_60734_().getRegistryName())) {
            Direction benchFacing = this.getBenchToJoinToFacing(benchAxis, world, pos);
            boolean defaultFacing = true;
            if (this.getBenchType(blockStateToJoinTo) == BenchType.SINGLE) {
                if (benchFacing == Direction.NORTH && benchAxis == Direction.EAST) {
                    benchFacing = Swivel.Rotate((Direction)benchAxis, (Rotation)Rotation.TwoSeventy);
                    defaultFacing = false;
                }
                if (benchFacing == Direction.EAST && benchAxis == Direction.SOUTH) {
                    benchFacing = Swivel.Rotate((Direction)benchAxis, (Rotation)Rotation.TwoSeventy);
                    defaultFacing = false;
                }
                if (benchFacing == Direction.SOUTH && benchAxis == Direction.WEST) {
                    benchFacing = Swivel.Rotate((Direction)benchAxis, (Rotation)Rotation.TwoSeventy);
                    defaultFacing = false;
                }
                if (benchFacing == Direction.WEST && benchAxis == Direction.NORTH) {
                    benchFacing = Swivel.Rotate((Direction)benchAxis, (Rotation)Rotation.TwoSeventy);
                    defaultFacing = false;
                }
                if (defaultFacing) {
                    benchFacing = Swivel.Rotate((Direction)benchAxis, (Rotation)Rotation.Ninty);
                }
            }
            stateForPlacement = this.traceBench2(benchAxis, (LevelAccessor)world, pos, stateForPlacement, benchFacing);
        }
        return stateForPlacement;
    }

    private boolean isIAFBench(BlockState blockstate) {
        ResourceLocation resource = blockstate.m_60734_().getRegistryName();
        return resource.m_135827_().equals("everycomp") && resource.m_135815_().contains("bench");
    }

    protected BenchType getBenchType(BlockState blockstate) {
        if (blockstate == null) {
            return null;
        }
        return this.isIAFBench(blockstate) ? (BenchType)blockstate.m_61143_((Property)TYPE) : null;
    }

    private Direction getBenchDirection(BlockState blockstate) {
        return this.isIAFBench(blockstate) ? (Direction)blockstate.m_61143_((Property)DIRECTION) : null;
    }

    private int getOffset(Direction direction, LevelAccessor world, BlockPos pos) {
        int offset = 0;
        BlockState currentlyInspectedBenchState = world.m_8055_(pos.m_142300_(direction));
        BenchType currentlyInspectedBenchType = this.getBenchType(currentlyInspectedBenchState);
        if (this.isBenchPiece(currentlyInspectedBenchType)) {
            String blockName;
            Direction blockFacing = Swivel.Rotate((Direction)this.getBenchDirection(currentlyInspectedBenchState), (Rotation)Rotation.Ninty);
            String currentlyInspectedBlockName = blockName = currentlyInspectedBenchState.m_60734_().getRegistryName().m_135827_();
            while (this.isBenchPieceOnAxis(currentlyInspectedBenchType, direction, blockFacing, blockName, currentlyInspectedBlockName)) {
                currentlyInspectedBenchState = world.m_8055_(pos.m_5484_(direction, ++offset + 1));
                currentlyInspectedBenchType = this.getBenchType(currentlyInspectedBenchState);
                currentlyInspectedBlockName = currentlyInspectedBenchState.m_60734_().getRegistryName().m_135827_();
                if (!this.isBenchPiece(currentlyInspectedBenchType)) continue;
                blockFacing = Swivel.Rotate((Direction)this.getBenchDirection(currentlyInspectedBenchState), (Rotation)Rotation.Ninty);
            }
        }
        return offset;
    }

    private BlockState traceBench2(Direction direction, LevelAccessor world, BlockPos pos, BlockState blockState, Direction benchFacing) {
        BlockPos workingBlockPos;
        boolean invertLeftRight = false;
        if (benchFacing == Direction.NORTH && direction == Direction.EAST) {
            invertLeftRight = true;
        }
        if (benchFacing == Direction.EAST && direction == Direction.SOUTH) {
            invertLeftRight = true;
        }
        if (benchFacing == Direction.SOUTH && direction == Direction.WEST) {
            invertLeftRight = true;
        }
        if (benchFacing == Direction.WEST && direction == Direction.NORTH) {
            invertLeftRight = true;
        }
        BenchType left = BenchType.LEFT;
        BenchType right = BenchType.RIGHT;
        if (invertLeftRight) {
            left = BenchType.RIGHT;
            right = BenchType.LEFT;
        }
        int positiveOffset = this.getOffset(direction.m_122424_(), world, pos);
        int negativeOffset = this.getOffset(direction, world, pos);
        int workingPositiveOffset = positiveOffset;
        if (positiveOffset == 0 && negativeOffset == 0) {
            return (BlockState)((BlockState)blockState.m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)BenchType.SINGLE);
        }
        for (int workingNegativeOffset = negativeOffset; workingNegativeOffset > 0; --workingNegativeOffset) {
            workingBlockPos = pos.m_5484_(direction, workingNegativeOffset);
            if (workingNegativeOffset == negativeOffset) {
                world.m_7731_(workingBlockPos, (BlockState)((BlockState)world.m_8055_(workingBlockPos).m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)left), 0);
                continue;
            }
            world.m_7731_(workingBlockPos, (BlockState)((BlockState)world.m_8055_(workingBlockPos).m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)BenchType.MIDDLE), 0);
        }
        if (negativeOffset > 0 && positiveOffset == 0) {
            return (BlockState)((BlockState)blockState.m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)right);
        }
        while (workingPositiveOffset > 0) {
            workingBlockPos = pos.m_5484_(direction.m_122424_(), workingPositiveOffset);
            if (workingPositiveOffset == positiveOffset) {
                world.m_7731_(workingBlockPos, (BlockState)((BlockState)world.m_8055_(workingBlockPos).m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)right), 0);
            } else {
                world.m_7731_(workingBlockPos, (BlockState)((BlockState)world.m_8055_(workingBlockPos).m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)BenchType.MIDDLE), 0);
            }
            --workingPositiveOffset;
        }
        if (positiveOffset > 0 && negativeOffset == 0) {
            return (BlockState)((BlockState)blockState.m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)left);
        }
        return (BlockState)((BlockState)blockState.m_61124_((Property)DIRECTION, (Comparable)benchFacing)).m_61124_((Property)TYPE, (Comparable)BenchType.MIDDLE);
    }

    private boolean isBenchPiece(BenchType benchType) {
        return benchType == BenchType.SINGLE || benchType == BenchType.MIDDLE || benchType == BenchType.LEFT || benchType == BenchType.RIGHT;
    }

    private boolean isBenchPieceOnAxis(BenchType benchType, Direction benchAxis, Direction blockAxis, String blockName, String currentBlockName) {
        if (!blockName.equals(currentBlockName)) {
            return false;
        }
        if (benchType == BenchType.SINGLE) {
            return true;
        }
        return !(benchType != BenchType.MIDDLE && benchType != BenchType.LEFT && benchType != BenchType.RIGHT || benchAxis != blockAxis && benchAxis != blockAxis.m_122424_());
    }

    private Rotation GetOpposite(Rotation rotation) {
        switch (rotation) {
            case Ninty: {
                return Rotation.TwoSeventy;
            }
            case OneEighty: {
                return Rotation.Zero;
            }
            case TwoSeventy: {
                return Rotation.Ninty;
            }
            case Zero: {
                return Rotation.OneEighty;
            }
        }
        return Rotation.Zero;
    }

    private boolean isBenchEnd(Direction facing, Level world, BlockPos pos) {
        BenchType benchType = this.getBenchType(world.m_8055_(pos.m_142300_(facing)));
        return benchType == BenchType.LEFT || benchType == BenchType.RIGHT;
    }

    private boolean isBenchSingle(Direction facing, Level world, BlockPos pos) {
        BenchType benchType = this.getBenchType(world.m_8055_(pos.m_142300_(facing)));
        return benchType == BenchType.SINGLE;
    }

    private Direction getBenchToJoinToFacing(Direction benchDirection, Level world, BlockPos pos) {
        return this.getBenchDirection(world.m_8055_(pos.m_142300_(benchDirection)));
    }

    private Direction getBenchToJoinTo(Direction playerFacing, Level world, BlockPos pos) {
        if (this.isBenchEnd(playerFacing, world, pos) || this.isBenchSingle(playerFacing, world, pos)) {
            if (this.isBenchSingle(playerFacing, world, pos)) {
                return playerFacing;
            }
            Direction targetFace = this.getBenchDirection(world.m_8055_(pos.m_142300_(playerFacing)));
            if (targetFace == null) {
                return null;
            }
            targetFace = Swivel.Rotate((Direction)targetFace, (Rotation)Rotation.Ninty);
            if (this.isBenchEnd(playerFacing, world, pos) && (targetFace == playerFacing || targetFace == playerFacing.m_122424_())) {
                return playerFacing;
            }
        }
        for (Direction face : Direction.values()) {
            if (face == Direction.UP || face == Direction.DOWN) continue;
            if (this.isBenchSingle(face, world, pos)) {
                return face;
            }
            if (!this.isBenchEnd(face, world, pos)) continue;
            Direction targetFace = this.getBenchDirection(world.m_8055_(pos.m_142300_(face)));
            if (targetFace == null) {
                return null;
            }
            if ((targetFace = Swivel.Rotate((Direction)targetFace, (Rotation)Rotation.Ninty)) != face && targetFace != face.m_122424_()) continue;
            return face;
        }
        return null;
    }

    public void m_6786_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        Direction benchFacing = this.getBenchDirection(state);
        Rotation defaultRotation = Rotation.Ninty;
        Direction benchAxis = Swivel.Rotate((Direction)this.getBenchDirection(state), (Rotation)defaultRotation);
        BenchType benchType = this.getBenchType(state);
        super.m_6786_(worldIn, pos, state);
        if (benchAxis != null && benchType != null && benchType != BenchType.SINGLE) {
            BlockState reverseOffsetBlockState;
            Direction reverseOffsetFacing;
            BlockState reverseCurrentOffsetBlockState;
            BenchType reverseOffsetType;
            BlockState offsetBlockState;
            Direction currentOffsetFacing;
            BlockState currentOffsetBlockState = worldIn.m_8055_(pos.m_142300_(benchAxis));
            BenchType currentOffsetType = this.getBenchType(currentOffsetBlockState);
            if (currentOffsetType != null && ((currentOffsetFacing = Swivel.Rotate((Direction)this.getBenchDirection(currentOffsetBlockState), (Rotation)defaultRotation)) == benchAxis || currentOffsetFacing == benchAxis.m_122424_()) && (offsetBlockState = this.traceBench2(benchAxis, worldIn, pos.m_142300_(benchAxis), worldIn.m_8055_(pos.m_142300_(benchAxis)), benchFacing)) != null && this.isBenchPiece(this.getBenchType(offsetBlockState))) {
                worldIn.m_7731_(pos.m_142300_(benchAxis), offsetBlockState, 0);
            }
            if ((reverseOffsetType = this.getBenchType(reverseCurrentOffsetBlockState = worldIn.m_8055_(pos.m_142300_(benchAxis.m_122424_())))) != null && ((reverseOffsetFacing = Swivel.Rotate((Direction)this.getBenchDirection(reverseCurrentOffsetBlockState), (Rotation)this.GetOpposite(defaultRotation))) == benchAxis || reverseOffsetFacing == benchAxis.m_122424_()) && (reverseOffsetBlockState = this.traceBench2(benchAxis.m_122424_(), worldIn, pos.m_142300_(benchAxis.m_122424_()), worldIn.m_8055_(pos.m_142300_(benchAxis.m_122424_())), benchFacing)) != null && this.isBenchPiece(this.getBenchType(reverseOffsetBlockState))) {
                worldIn.m_7731_(pos.m_142300_(benchAxis.m_122424_()), reverseOffsetBlockState, 0);
            }
        }
    }
}

