/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.api.cookingforblockheads.capability;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.Action;
import dev.smolinacadena.refinedcooking.blockentity.KitchenStationBlockEntity;
import dev.smolinacadena.refinedcooking.network.KitchenStationNetworkNode;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.minecraft.world.item.ItemStack;

public class KitchenItemProvider
implements IKitchenItemProvider {
    private final KitchenStationBlockEntity tile;
    private final HashMap<String, Integer> usedStackSizes;

    public KitchenItemProvider(KitchenStationBlockEntity tile) {
        this.tile = tile;
        this.usedStackSizes = new HashMap();
    }

    public INetwork getNetwork() {
        return ((KitchenStationNetworkNode)this.tile.getNode()).getNetwork();
    }

    public void resetSimulation() {
        this.usedStackSizes.replaceAll((n, v) -> 0);
    }

    public int getSimulatedUseCount(int slot) {
        return 0;
    }

    public int getSimulatedUseCount(String key) {
        return this.usedStackSizes.getOrDefault(key, 0);
    }

    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        return ItemStack.f_41583_;
    }

    public void useItemStack(ItemStack itemStack, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        String itemRegistryName = itemStack.m_41720_().getRegistryName().toString();
        if (itemStack.m_41613_() - (simulate ? this.usedStackSizes.getOrDefault(itemRegistryName, 0) : 0) >= amount) {
            ItemStack result = this.getNetwork().extractItem(itemStack, amount, simulate ? Action.SIMULATE : Action.PERFORM);
            if (simulate && !result.m_41619_()) {
                this.usedStackSizes.put(itemRegistryName, this.usedStackSizes.getOrDefault(itemRegistryName, 0) + result.m_41613_());
            }
        }
    }

    public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
        return this.getNetwork().insertItem(itemStack, itemStack.m_41613_(), Action.PERFORM);
    }

    public int getSlots() {
        return this.getNetwork() != null ? this.getNetwork().getItemStorageCache().getList().size() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack returnItemStack(ItemStack itemStack) {
        return itemStack;
    }

    @Nullable
    public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        if (this.getNetwork() != null && predicate instanceof IngredientPredicateWithCache) {
            IngredientPredicateWithCache predicateWithItems = (IngredientPredicateWithCache)predicate;
            for (ItemStack ingredient : predicateWithItems.getItems()) {
                ItemStack ingredientStackFromNetwork = (ItemStack)this.getNetwork().getItemStorageCache().getList().get((Object)ingredient);
                if (ingredientStackFromNetwork == null || ingredientStackFromNetwork.m_41619_() || !predicate.test(ingredientStackFromNetwork, ingredientStackFromNetwork.m_41613_() - this.getSimulatedUseCount(ingredientStackFromNetwork.m_41778_()))) continue;
                return new SourceItem((IKitchenItemProvider)this, 0, ingredientStackFromNetwork.m_41777_());
            }
        }
        return null;
    }

    @Nullable
    public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        SourceItem sourceItem = this.findSource(predicate, maxAmount, inventories, requireBucket, simulate);
        if (sourceItem != null) {
            this.useItemStack(sourceItem.getSourceStack(), Math.min(sourceItem.getSourceStack().m_41613_(), maxAmount), simulate, inventories, requireBucket);
        }
        return sourceItem;
    }

    public void consumeSourceItem(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireContainer) {
        if (sourceItem.getSourceSlot() < 0) {
            return;
        }
        this.useItemStack(sourceItem.getSourceStack(), maxAmount, false, inventories, requireContainer);
    }

    public void markAsUsed(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        this.useItemStack(sourceItem.getSourceStack(), Math.min(sourceItem.getSourceStack().m_41613_(), maxAmount), true, inventories, requireBucket);
    }
}

