/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.blockentity;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.mojang.datafixers.util.Pair;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import dev.smolinacadena.refinedcooking.RefinedCookingBlockEntities;
import dev.smolinacadena.refinedcooking.RefinedCookingBlocks;
import dev.smolinacadena.refinedcooking.api.cookingforblockheads.capability.KitchenItemProvider;
import dev.smolinacadena.refinedcooking.block.KitchenStationBlock;
import dev.smolinacadena.refinedcooking.network.KitchenStationNetworkNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlockEntityContract;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.provider.BalmProviderHolder;
import net.blay09.mods.balm.forge.container.BalmInvWrapper;
import net.blay09.mods.balm.forge.energy.ForgeEnergyStorage;
import net.blay09.mods.balm.forge.fluid.ForgeFluidTank;
import net.blay09.mods.balm.forge.provider.ForgeBalmProviders;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitchenStationBlockEntity
extends NetworkNodeBlockEntity<KitchenStationNetworkNode>
implements BalmBlockEntityContract {
    private final Map<Capability<?>, LazyOptional<?>> capabilities = new HashMap();
    private final Table<Capability<?>, Direction, LazyOptional<?>> sidedCapabilities = HashBasedTable.create();
    private boolean capabilitiesInitialized;
    private final KitchenItemProvider itemProvider = new KitchenItemProvider(this);

    public KitchenStationBlockEntity(BlockPos pos, BlockState state) {
        super(RefinedCookingBlockEntities.KITCHEN_STATION, pos, state);
    }

    private void addCapabilities(BalmProvider<?> provider, Map<Capability<?>, LazyOptional<?>> capabilities) {
        ForgeBalmProviders forgeProviders = (ForgeBalmProviders)Balm.getProviders();
        Capability capability = forgeProviders.getCapability(provider.getProviderClass());
        capabilities.put(capability, LazyOptional.of(() -> provider.getInstance()));
        if (provider.getProviderClass() == Container.class) {
            capabilities.put(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> new BalmInvWrapper((Container)provider.getInstance())));
        } else if (provider.getProviderClass() == FluidTank.class) {
            capabilities.put(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(() -> new ForgeFluidTank((FluidTank)provider.getInstance())));
        } else if (provider.getProviderClass() == EnergyStorage.class) {
            capabilities.put(CapabilityEnergy.ENERGY, LazyOptional.of(() -> new ForgeEnergyStorage((EnergyStorage)provider.getInstance())));
        }
    }

    public <T> T getProvider(Class<T> clazz) {
        ForgeBalmProviders forgeProviders = (ForgeBalmProviders)Balm.getProviders();
        Capability capability = forgeProviders.getCapability(clazz);
        return this.getCapability(capability).resolve().orElse(null);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.capabilitiesInitialized) {
            ArrayList providers = new ArrayList();
            this.buildProviders(providers);
            for (BalmProviderHolder providerHolder : providers) {
                for (BalmProvider provider : providerHolder.getProviders()) {
                    this.addCapabilities(provider, this.capabilities);
                }
                for (Pair pair : providerHolder.getSidedProviders()) {
                    Direction direction = (Direction)pair.getFirst();
                    BalmProvider provider = (BalmProvider)pair.getSecond();
                    Map sidedCapabilities = this.sidedCapabilities.column((Object)direction);
                    this.addCapabilities(provider, sidedCapabilities);
                }
            }
            this.capabilitiesInitialized = true;
        }
        LazyOptional<?> result = null;
        if (side != null) {
            result = (LazyOptional<?>)this.sidedCapabilities.get(cap, (Object)side);
        }
        if (result == null) {
            result = this.capabilities.get(cap);
        }
        return result != null ? result.cast() : super.getCapability(cap, side);
    }

    @Nonnull
    public KitchenStationNetworkNode createNode(Level level, BlockPos pos) {
        return new KitchenStationNetworkNode(level, pos);
    }

    public void setConnected(boolean connected) {
        this.f_58857_.m_7696_(this.f_58858_, (Block)RefinedCookingBlocks.KITCHEN_STATION.get(), 0, 0);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)KitchenStationBlock.CONNECTED, (Comparable)Boolean.valueOf(connected)));
        this.m_6596_();
    }
}

