/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.network;

import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import dev.smolinacadena.refinedcooking.RefinedCooking;
import dev.smolinacadena.refinedcooking.RefinedCookingItems;
import dev.smolinacadena.refinedcooking.blockentity.KitchenAccessPointBlockEntity;
import dev.smolinacadena.refinedcooking.blockentity.KitchenStationBlockEntity;
import dev.smolinacadena.refinedcooking.item.KitchenNetworkCardItem;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class KitchenAccessPointNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedcooking", "kitchen_access_point");
    private BlockPos receiver;
    private ResourceKey<Level> receiverDimension;
    private final BaseItemHandler networkCard = new BaseItemHandler(1).addValidator((Predicate)new ItemValidator((Item)RefinedCookingItems.KITCHEN_NETWORK_CARD.get())).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        ItemStack card = handler.getStackInSlot(slot);
        if (card.m_41619_()) {
            BlockEntity tile;
            this.receiver = null;
            this.receiverDimension = null;
            if (!reading && (tile = this.level.m_7702_(this.pos)) instanceof KitchenAccessPointBlockEntity) {
                ((KitchenAccessPointBlockEntity)tile).setHasCard(false);
            }
        } else {
            BlockEntity tile;
            this.receiver = KitchenNetworkCardItem.getReceiver(card);
            this.receiverDimension = KitchenNetworkCardItem.getDimension(card);
            if (!reading && (tile = this.level.m_7702_(this.pos)) instanceof KitchenAccessPointBlockEntity) {
                ((KitchenAccessPointBlockEntity)tile).setHasCard(true);
            }
        }
        if (this.network != null) {
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getLevel(), this.network.getPosition());
        }
    });

    public KitchenAccessPointNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.networkCard, (int)0, (CompoundTag)tag);
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.networkCard, (int)0, (CompoundTag)tag);
    }

    public ResourceLocation getId() {
        return ID;
    }

    public int getEnergyUsage() {
        return RefinedCooking.SERVER_CONFIG.getKitchenAccessPoint().getUsage();
    }

    public BaseItemHandler getNetworkCard() {
        return this.networkCard;
    }

    public IItemHandler getDrops() {
        return this.getNetworkCard();
    }

    @Nullable
    public ResourceKey<Level> getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null || this.receiverDimension == null || !this.isSameDimension()) {
            return -1;
        }
        return (int)Math.sqrt(Math.pow(this.pos.m_123341_() - this.receiver.m_123341_(), 2.0) + Math.pow(this.pos.m_123342_() - this.receiver.m_123342_(), 2.0) + Math.pow(this.pos.m_123343_() - this.receiver.m_123343_(), 2.0));
    }

    public boolean isSameDimension() {
        return this.level.m_46472_() == this.receiverDimension;
    }

    private boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.receiverDimension != null;
    }

    public boolean shouldRebuildGraphOnChange() {
        return true;
    }

    public void visit(INetworkNodeVisitor.Operator operator) {
        super.visit(operator);
        if (this.canTransmit()) {
            if (!this.isSameDimension()) {
                ServerLevel dimensionWorld = this.level.m_142572_().m_129880_(this.receiverDimension);
                if (dimensionWorld != null && dimensionWorld.m_7702_(this.receiver) instanceof KitchenStationBlockEntity) {
                    operator.apply((Level)dimensionWorld, this.receiver, null);
                }
            } else if (this.level.m_7702_(this.receiver) instanceof KitchenStationBlockEntity) {
                operator.apply(this.level, this.receiver, null);
            }
        }
    }
}

