/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters;

import appeng.api.stacks.AEItemKey;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.joseph.vaultfilters.VFTests;
import net.joseph.vaultfilters.VaultFilters;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VFCache {
    private static final Cache<Object, ConcurrentHashMap<Object, Boolean>> ITEM_OUTER_CACHE = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public static ItemStack getStackFromObject(Object object) {
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return stack;
        }
        if (object instanceof AEItemKey) {
            AEItemKey key = (AEItemKey)object;
            return key.toStack();
        }
        VaultFilters.LOGGER.warn("UNDETECTED Object type");
        return ItemStack.f_41583_;
    }

    public static boolean getOrCreateFilter(Object stack, Object filterStack, Level level) {
        ConcurrentHashMap<Object, Boolean> FILTER_INNER_CACHE = (ConcurrentHashMap<Object, Boolean>)ITEM_OUTER_CACHE.getIfPresent(stack);
        if (FILTER_INNER_CACHE == null) {
            FILTER_INNER_CACHE = new ConcurrentHashMap<Object, Boolean>();
            boolean result = VFTests.basicFilterTest(VFCache.getStackFromObject(stack), filterStack, level);
            FILTER_INNER_CACHE.put(filterStack, result);
            ITEM_OUTER_CACHE.put(stack, FILTER_INNER_CACHE);
            return result;
        }
        if (FILTER_INNER_CACHE.containsKey(filterStack)) {
            return (Boolean)FILTER_INNER_CACHE.get(filterStack);
        }
        boolean result = VFTests.basicFilterTest(VFCache.getStackFromObject(stack), filterStack, level);
        FILTER_INNER_CACHE.put(filterStack, result);
        return result;
    }
}

