/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters;

import appeng.api.stacks.AEItemKey;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import net.joseph.vaultfilters.DataFixers;
import net.joseph.vaultfilters.VFCache;
import net.joseph.vaultfilters.VaultFilters;
import net.joseph.vaultfilters.configs.VFServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class VFTests {
    public static String filterKey = "hashes";
    private static Level level;

    public static boolean checkFilter(ItemStack stack, Object filterStack, boolean useCache, Level level) {
        if (!useCache) {
            return VFTests.basicFilterTest(stack, filterStack, level);
        }
        Item stackItem = stack.m_41720_();
        if (((Boolean)VFServerConfig.CACHE_DATAFIX.get()).booleanValue() && filterStack instanceof ItemStack) {
            DataFixers.clearNBTCache(stack);
        }
        return VFCache.getOrCreateFilter(stack, filterStack, level);
    }

    public static boolean checkFilter(AEItemKey stack, Object filterStack, boolean useCache, Level level) {
        if (!useCache) {
            return VFTests.basicFilterTest(stack.toStack(), filterStack, level);
        }
        return VFCache.getOrCreateFilter(stack, filterStack, level);
    }

    public static boolean basicFilterTest(ItemStack stack, Object filterStack, Level level) {
        if (level == null) {
            level = (Level)DistExecutor.unsafeRunForDist(() -> VFTests::getClientLevel, () -> () -> level);
        }
        if (filterStack instanceof ItemStack) {
            ItemStack stackFilter = (ItemStack)filterStack;
            return FilterItemStack.of((ItemStack)stackFilter).test(level, stack);
        }
        if (filterStack instanceof FilterItemStack) {
            FilterItemStack filterItemStack = (FilterItemStack)filterStack;
            return filterItemStack.test(level, stack);
        }
        if (filterStack instanceof AEItemKey) {
            AEItemKey aeItemKey = (AEItemKey)filterStack;
            return FilterItemStack.of((ItemStack)aeItemKey.toStack()).test(level, stack);
        }
        VaultFilters.LOGGER.debug("[0.5.1.f] invalid filter entered");
        return false;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        MinecraftServer server = event.getWorld().m_142572_();
        if (server != null) {
            level = server.m_129880_(Level.f_46428_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }
}

