/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceListGearAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectCloudAttribute;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.reader.IncreasedPercentageReader;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.base.Skill;
import java.util.ArrayList;
import java.util.List;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.joseph.vaultfilters.mixin.data.EffectCloudAccessor;
import net.joseph.vaultfilters.mixin.data.EffectCloudAttributeAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public abstract class AffixAttribute
extends StringAttribute {
    protected AffixAttribute(String value) {
        super(value);
    }

    public abstract VaultGearModifier.AffixType getAffixType();

    public boolean shouldList(VaultGearModifier<?> modifier) {
        return true;
    }

    @Override
    public ItemAttribute withValue(VaultGearModifier<?> modifier) {
        String name = AffixAttribute.getName(modifier);
        return name.isBlank() ? null : this.withValue(name);
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.hasModifier(this.getAffixType(), itemStack);
    }

    public boolean checkModifier(VaultGearModifier<?> modifier) {
        return ((String)this.value).equals(AffixAttribute.getName(modifier));
    }

    public boolean hasModifier(VaultGearModifier.AffixType type, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof VaultGearItem) {
            Iterable<VaultGearModifier<?>> modifiers = this.getModifiers(itemStack, type);
            for (VaultGearModifier<?> modifier : modifiers) {
                if (!this.checkModifier(modifier)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> String getName(VaultGearModifier<T> modifier) {
        Object cloud;
        Object object = modifier.getValue();
        if (object instanceof EffectCloudAttribute) {
            EffectCloudAttribute cloudAttribute = (EffectCloudAttribute)object;
            cloud = ((EffectCloudAttributeAccessor)cloudAttribute).getEffectCloud();
            boolean whenHit = modifier.getAttribute().getReader().getModifierName().contains("Hit");
            String tooltip = ((EffectCloudAccessor)cloud).getTooltip();
            String cloudType = (tooltip.contains(" ") ? tooltip.substring(0, tooltip.lastIndexOf(32)) : tooltip) + " Cloud";
            return cloudType + (whenHit ? " when Hit" : "");
        }
        cloud = modifier.getValue();
        if (cloud instanceof AbilityLevelAttribute) {
            AbilityLevelAttribute levelAttribute = (AbilityLevelAttribute)cloud;
            String ability = levelAttribute.getAbility().equals("all_abilities") ? "All Abilities" : ModConfigs.ABILITIES.getAbilityById(levelAttribute.getAbility()).map(Skill::getName).orElse("");
            return "level of " + ability;
        }
        object = modifier.getValue();
        if (object instanceof EffectAvoidanceGearAttribute) {
            EffectAvoidanceGearAttribute avoidanceAttribute = (EffectAvoidanceGearAttribute)object;
            return avoidanceAttribute.getEffect().m_19482_().getString() + " Avoidance";
        }
        object = modifier.getValue();
        if (object instanceof EffectAvoidanceListGearAttribute) {
            EffectAvoidanceListGearAttribute effAvAttribute = (EffectAvoidanceListGearAttribute)object;
            return "Effect Avoidance";
        }
        VaultGearModifierReader reader = modifier.getAttribute().getReader();
        if (reader instanceof IncreasedPercentageReader) {
            return "Increased " + reader.getModifierName();
        }
        return reader.getModifierName();
    }

    public Iterable<VaultGearModifier<?>> getModifiers(ItemStack itemStack, VaultGearModifier.AffixType type) {
        if (itemStack.m_41720_() instanceof VaultGearItem) {
            return type == null ? VaultGearData.read((ItemStack)itemStack).getAllModifierAffixes() : VaultGearData.read((ItemStack)itemStack).getModifiers(type);
        }
        return new ArrayList();
    }

    @Override
    public String getValue(ItemStack itemStack) {
        return null;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        for (VaultGearModifier<?> modifier : this.getModifiers(itemStack, this.getAffixType())) {
            ItemAttribute itemAtt;
            if (!this.shouldList(modifier) || (itemAtt = this.withValue(modifier)) == null) continue;
            attributes.add(itemAtt);
        }
        return attributes;
    }

    @Override
    public ItemAttribute readNBT(CompoundTag compoundTag) {
        String key = this.getTranslationKey();
        if (compoundTag.m_128425_(key, 8)) {
            return this.withValue(compoundTag.m_128461_(key));
        }
        String affix = compoundTag.m_128461_(this.getLegacyKey());
        if (affix.contains("level")) {
            affix = affix.substring(6);
        }
        compoundTag.m_128359_(key, affix);
        compoundTag.m_128473_(this.getLegacyKey());
        return this.withValue(affix);
    }
}

