/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.joseph.vaultfilters.attributes.abstracts.VaultAttribute;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public abstract class DoubleAttribute
extends VaultAttribute<Double> {
    private static final Map<Class<?>, Function<Double, DoubleAttribute>> factories = new HashMap();

    protected DoubleAttribute(Double value) {
        super(value);
    }

    public void register(Function<Double, DoubleAttribute> factory) {
        factories.put(this.getClass(), factory);
        super.register();
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        Double value = (Double)this.getValue(itemStack);
        return value != null && value >= (Double)this.value;
    }

    public DoubleAttribute withValue(Double value) {
        return factories.getOrDefault(this.getClass(), ignored -> null).apply(value);
    }

    public void writeNBT(CompoundTag compoundTag) {
        compoundTag.m_128347_(this.getTranslationKey(), ((Double)this.value).doubleValue());
    }

    public ItemAttribute readNBT(CompoundTag compoundTag) {
        String key = this.getTranslationKey();
        byte type = compoundTag.m_128435_(key);
        if (type == 6) {
            return this.withValue(compoundTag.m_128459_(key));
        }
        if (type == 8) {
            DoubleAttribute attribute = this.withValue(Double.parseDouble(compoundTag.m_128461_(key)));
            compoundTag.m_128347_(key, ((Double)attribute.value).doubleValue());
            return attribute;
        }
        DoubleAttribute attribute = this.withValue(Double.parseDouble(compoundTag.m_128461_(this.getLegacyKey())));
        compoundTag.m_128347_(key, ((Double)attribute.value).doubleValue());
        compoundTag.m_128473_(this.getLegacyKey());
        return attribute;
    }
}

