/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.joseph.vaultfilters.VFTests;
import net.joseph.vaultfilters.attributes.abstracts.VaultAttribute;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class InnerFilterAttribute
extends VaultAttribute<ItemStack> {
    private static final Map<Class<?>, Function<ItemStack, InnerFilterAttribute>> factories = new HashMap();

    protected InnerFilterAttribute(ItemStack value) {
        super(value);
    }

    public abstract List<ItemStack> getInnerItems(ItemStack var1);

    public void register(Function<ItemStack, InnerFilterAttribute> factory) {
        factories.put(this.getClass(), factory);
        super.register();
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        List<ItemStack> innerItems = this.getInnerItems(itemStack);
        if (innerItems == null) {
            return false;
        }
        for (ItemStack item : innerItems) {
            if (!VFTests.basicFilterTest(item, this.value, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        if (itemStack.m_41720_() instanceof FilterItem) {
            attributes.add(this.withValue(itemStack));
        }
        return attributes;
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{((ItemStack)this.value).m_41611_().getString()};
    }

    @Override
    public ItemAttribute withValue(ItemStack value) {
        return factories.getOrDefault(this.getClass(), ignored -> null).apply(value);
    }

    public void writeNBT(CompoundTag compoundTag) {
        compoundTag.m_128365_(this.getTranslationKey(), (Tag)((ItemStack)this.value).m_41739_(new CompoundTag()));
    }

    public ItemAttribute readNBT(CompoundTag compoundTag) {
        return this.withValue(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(this.getTranslationKey())));
    }

    @Override
    public ItemStack getValue(ItemStack itemStack) {
        return itemStack;
    }
}

