/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.joseph.vaultfilters.attributes.abstracts.Objects.Modifier;
import net.joseph.vaultfilters.attributes.abstracts.VaultAttribute;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public abstract class ModifierAttribute
extends VaultAttribute<Modifier> {
    private static final Map<Class<?>, Function<Modifier, ModifierAttribute>> factories = new HashMap();

    protected ModifierAttribute(Modifier value) {
        super(value);
    }

    public void register(Function<Modifier, ModifierAttribute> factory) {
        factories.put(this.getClass(), factory);
        super.register();
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        Modifier value = (Modifier)this.getValue(itemStack);
        if (value == null) {
            return false;
        }
        return ((Modifier)this.value).getLevel().getClass().isInstance(value.getLevel()) && value.getLevel().floatValue() >= ((Modifier)this.value).getLevel().floatValue() && ((Modifier)this.value).getNormalName().equals(value.getNormalName());
    }

    public ModifierAttribute withValue(Modifier value) {
        return factories.getOrDefault(this.getClass(), ignored -> null).apply(value);
    }

    public void writeNBT(CompoundTag compoundTag) {
        compoundTag.m_128359_(this.getTranslationKey(), ((Modifier)this.value).getDisplayName());
        this.writeLevel(compoundTag, ((Modifier)this.value).getLevel());
        compoundTag.m_128359_(this.getTranslationKey() + "_simple", ((Modifier)this.value).getNormalName());
    }

    public void writeLevel(CompoundTag compoundTag, Number level) {
        String levelKey = this.getTranslationKey() + "_level";
        if (level instanceof Float) {
            Float f = (Float)level;
            compoundTag.m_128350_(levelKey, f.floatValue());
        } else if (level instanceof Double) {
            Double d = (Double)level;
            compoundTag.m_128347_(levelKey, d.doubleValue());
        } else if (level instanceof Integer) {
            Integer i = (Integer)level;
            compoundTag.m_128405_(levelKey, i.intValue());
        }
    }

    public ItemAttribute readNBT(CompoundTag compoundTag) {
        String key = this.getTranslationKey();
        String simpleKey = key + "_simple";
        String levelKey = key + "_level";
        Number level = null;
        byte levelType = compoundTag.m_128435_(levelKey);
        if (levelType == 5) {
            level = Float.valueOf(compoundTag.m_128457_(levelKey));
        } else if (levelType == 6) {
            level = compoundTag.m_128459_(levelKey);
        } else if (levelType == 3) {
            level = compoundTag.m_128451_(levelKey);
        }
        return this.withValue(new Modifier(compoundTag.m_128461_(key), compoundTag.m_128461_(simpleKey), level));
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{((Modifier)this.value).getDisplayName()};
    }
}

