/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.card;

import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardCondition;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardNeighborType;
import iskallia.vault.item.CardItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.joseph.vaultfilters.attributes.abstracts.StringListAttribute;
import net.joseph.vaultfilters.mixin.data.CardConditionAccessor;
import net.joseph.vaultfilters.mixin.data.CardEntryAccessor;
import net.joseph.vaultfilters.mixin.data.ConditionFilterAccessor;
import net.minecraft.world.item.ItemStack;

public class CardConditionGroupsAttribute
extends StringListAttribute {
    public CardConditionGroupsAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        return "";
    }

    @Override
    public List<String> getValues(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof CardItem)) {
            return null;
        }
        Card card = CardItem.getCard((ItemStack)itemStack);
        List entries = card.getEntries();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        CardEntry entry = (CardEntry)entries.get(0);
        CardCondition condition = ((CardEntryAccessor)entry).getCondition();
        if (condition == null) {
            return null;
        }
        Map<Integer, List<CardCondition.Filter>> filters = ((CardConditionAccessor)condition).getFilters();
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList<String> categoryList = new ArrayList<String>();
        for (int key : filters.keySet()) {
            for (CardCondition.Filter filter : filters.get(key)) {
                Set<String> groupFilter;
                Set<CardEntry.Color> colorFilter;
                Set<Integer> tierFilter;
                Set<CardNeighborType> neighborFilter = ((ConditionFilterAccessor)filter).getNeighborFilter();
                if (neighborFilter != null) {
                    for (CardNeighborType neighbor : neighborFilter) {
                        categoryList.add(neighbor.name());
                    }
                }
                if ((tierFilter = ((ConditionFilterAccessor)filter).getTierFilter()) != null) {
                    CardNeighborType neighbor;
                    neighbor = tierFilter.iterator();
                    while (neighbor.hasNext()) {
                        Integer tier = (Integer)neighbor.next();
                        categoryList.add("Tier " + String.valueOf(tier));
                    }
                }
                if ((colorFilter = ((ConditionFilterAccessor)filter).getColorFilter()) != null) {
                    for (CardEntry.Color color : colorFilter) {
                        categoryList.add(color.name());
                    }
                }
                if ((groupFilter = ((ConditionFilterAccessor)filter).getGroupFilter()) == null) continue;
                for (String group : groupFilter) {
                    categoryList.add(group);
                }
            }
        }
        return categoryList;
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{((String)this.value).charAt(0) + ((String)this.value).substring(1).toLowerCase()};
    }

    public String getTranslationKey() {
        return "card_condition_group";
    }
}

