/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.card;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardCondition;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.item.CardItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.joseph.vaultfilters.attributes.abstracts.IntAttribute;
import net.joseph.vaultfilters.mixin.data.CardConditionAccessor;
import net.joseph.vaultfilters.mixin.data.CardEntryAccessor;
import net.joseph.vaultfilters.mixin.data.ConditionFilterAccessor;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;

public class CardConditionNumAttribute
extends IntAttribute {
    public CardConditionNumAttribute(Integer value) {
        super(value);
    }

    @Override
    public Integer getValue(ItemStack itemStack) {
        return null;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        Tuple<Integer, Integer> counts = CardConditionNumAttribute.getCardMinMax(itemStack);
        if (counts == null) {
            return new ArrayList<ItemAttribute>();
        }
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        Integer minCount = (Integer)counts.m_14418_();
        Integer maxCount = (Integer)counts.m_14419_();
        if (minCount != null) {
            attributes.add(this.withValue(minCount));
        }
        if (maxCount != null) {
            attributes.add(this.withValue(maxCount));
        }
        return attributes;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        Tuple<Integer, Integer> counts = CardConditionNumAttribute.getCardMinMax(itemStack);
        if (counts == null) {
            return false;
        }
        Integer minCount = (Integer)counts.m_14418_();
        Integer maxCount = (Integer)counts.m_14419_();
        if (maxCount == null && minCount == null) {
            return false;
        }
        if (maxCount != null && minCount != null) {
            return (Integer)this.value >= minCount && (Integer)this.value <= maxCount;
        }
        if (maxCount != null) {
            return (Integer)this.value <= maxCount;
        }
        return (Integer)this.value >= minCount;
    }

    public String getTranslationKey() {
        return "card_condition_num";
    }

    public static Tuple<Integer, Integer> getCardMinMax(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof CardItem)) {
            return null;
        }
        Card card = CardItem.getCard((ItemStack)itemStack);
        List entries = card.getEntries();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        CardEntry entry = (CardEntry)entries.get(0);
        CardCondition condition = ((CardEntryAccessor)entry).getCondition();
        if (condition == null) {
            return null;
        }
        Map<Integer, List<CardCondition.Filter>> filters = ((CardConditionAccessor)condition).getFilters();
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        Tuple counts = new Tuple(null, null);
        for (int key : filters.keySet()) {
            for (CardCondition.Filter filter : filters.get(key)) {
                Integer tempMinCount = ((ConditionFilterAccessor)filter).getMinCount();
                Integer tempMaxCount = ((ConditionFilterAccessor)filter).getMaxCount();
                if (tempMinCount != null) {
                    counts.m_145023_((Object)tempMinCount);
                }
                if (tempMaxCount == null) continue;
                counts.m_145025_((Object)tempMaxCount);
            }
        }
        return counts;
    }
}

