/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.card;

import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.modifier.card.CardModifier;
import iskallia.vault.core.card.modifier.card.GearCardModifier;
import iskallia.vault.core.card.modifier.card.TaskLootCardModifier;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.loot.LootPool;
import iskallia.vault.core.world.loot.entry.LootEntry;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.talent.RandomVaultModifierAttribute;
import iskallia.vault.gear.reader.IncreasedPercentageReader;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.CardItem;
import iskallia.vault.skill.base.Skill;
import java.util.List;
import java.util.Optional;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.joseph.vaultfilters.mixin.data.GearCardModifierAccesor;
import net.joseph.vaultfilters.mixin.data.LootCardModifierConfigAccessor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CardModifierAttribute
extends StringAttribute {
    public CardModifierAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof CardItem)) {
            return null;
        }
        Card card = CardItem.getCard((ItemStack)itemStack);
        List entries = card.getEntries();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        CardEntry entry = (CardEntry)entries.get(0);
        if (entry == null) {
            return null;
        }
        CardModifier modifier = entry.getModifier();
        if (modifier == null) {
            return null;
        }
        if (modifier instanceof GearCardModifier) {
            GearCardModifier gearModifier = (GearCardModifier)modifier;
            return gearModifier.getAttribute() == null ? null : CardModifierAttribute.getName(gearModifier);
        }
        if (modifier instanceof TaskLootCardModifier) {
            TaskLootCardModifier lootModifier = (TaskLootCardModifier)modifier;
            return CardModifierAttribute.getName(lootModifier);
        }
        return null;
    }

    public static List<ItemStack> getItemStacks(TaskLootCardModifier lootModifier) {
        TaskLootCardModifier.Config config = (TaskLootCardModifier.Config)lootModifier.getConfig();
        if (config == null) {
            return null;
        }
        LootPool lootPool = ((LootCardModifierConfigAccessor)config).getLoot();
        if (lootPool == null) {
            return null;
        }
        Optional optLootEntry = lootPool.getRandom();
        if (optLootEntry.isEmpty()) {
            return null;
        }
        LootEntry lootEntry = (LootEntry)optLootEntry.get();
        return lootEntry.getStack((RandomSource)JavaRandom.ofNanoTime());
    }

    public static String getName(TaskLootCardModifier lootModifier) {
        List<ItemStack> itemStacks = CardModifierAttribute.getItemStacks(lootModifier);
        if (itemStacks == null || itemStacks.isEmpty()) {
            return null;
        }
        return new TranslatableComponent(itemStacks.get(0).m_41720_().m_5524_()).getString();
    }

    public static <T> String getName(GearCardModifier<T> cardModifier) {
        Object modifierLocation;
        Optional valueOpt = CardEntry.getForTier(((GearCardModifierAccesor)cardModifier).getValues(), (int)1);
        if (valueOpt.isEmpty()) {
            return null;
        }
        Object valueFinal = valueOpt.get();
        VaultGearAttributeInstance instance = new VaultGearAttributeInstance(cardModifier.getAttribute(), valueFinal);
        Object object = instance.getValue();
        if (object instanceof RandomVaultModifierAttribute) {
            RandomVaultModifierAttribute modifierAttribute = (RandomVaultModifierAttribute)object;
            modifierLocation = modifierAttribute.getModifier();
            if (modifierLocation == null) {
                return null;
            }
            Optional optModifier = VaultModifierRegistry.getOpt((ResourceLocation)modifierLocation);
            return optModifier.map(VaultModifier::getDisplayName).orElse(null);
        }
        modifierLocation = instance.getValue();
        if (modifierLocation instanceof AbilityLevelAttribute) {
            AbilityLevelAttribute levelAttribute = (AbilityLevelAttribute)modifierLocation;
            String ability = levelAttribute.getAbility().equals("all_abilities") ? "All Abilities" : ModConfigs.ABILITIES.getAbilityById(levelAttribute.getAbility()).map(Skill::getName).orElse("");
            return "level of " + ability;
        }
        VaultGearModifierReader reader = instance.getAttribute().getReader();
        if (reader instanceof IncreasedPercentageReader) {
            return "Increased " + reader.getModifierName();
        }
        return reader.getModifierName();
    }

    public String getTranslationKey() {
        return "card_modifier";
    }
}

