/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.card;

import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardNeighborType;
import iskallia.vault.core.card.CardScaler;
import iskallia.vault.item.CardItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.joseph.vaultfilters.attributes.abstracts.StringListAttribute;
import net.joseph.vaultfilters.mixin.data.CardScaleAccessor;
import net.joseph.vaultfilters.mixin.data.ScalerFilterAccessor;
import net.minecraft.world.item.ItemStack;

public class CardScaleTypesAttribute
extends StringListAttribute {
    public CardScaleTypesAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        return "";
    }

    @Override
    public List<String> getValues(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof CardItem)) {
            return null;
        }
        Card card = CardItem.getCard((ItemStack)itemStack);
        List entries = card.getEntries();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        CardEntry entry = (CardEntry)entries.get(0);
        CardScaler scaler = entry.getScaler();
        if (scaler == null) {
            return null;
        }
        Map<Integer, List<CardScaler.Filter>> filters = ((CardScaleAccessor)scaler).getFilters();
        if (filters == null) {
            return null;
        }
        ArrayList<String> categoryList = new ArrayList<String>();
        for (int key : filters.keySet()) {
            for (CardScaler.Filter filter : filters.get(key)) {
                Set<String> groupFilter;
                Set<CardEntry.Color> colorFilter;
                Set<Integer> tierFilter;
                Set<CardNeighborType> neighborFilter = ((ScalerFilterAccessor)filter).getNeighborFilter();
                if (neighborFilter != null) {
                    for (CardNeighborType neighbor : neighborFilter) {
                        categoryList.add(neighbor.name());
                    }
                }
                if ((tierFilter = ((ScalerFilterAccessor)filter).getTierFilter()) != null) {
                    CardNeighborType neighbor;
                    neighbor = tierFilter.iterator();
                    while (neighbor.hasNext()) {
                        Integer tier = (Integer)neighbor.next();
                        categoryList.add("Tier " + (Integer)tier);
                    }
                }
                if ((colorFilter = ((ScalerFilterAccessor)filter).getColorFilter()) != null) {
                    for (CardEntry.Color color : colorFilter) {
                        categoryList.add(color.name());
                    }
                }
                if ((groupFilter = ((ScalerFilterAccessor)filter).getGroupFilter()) == null) continue;
                categoryList.addAll(groupFilter);
            }
        }
        return categoryList;
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{((String)this.value).charAt(0) + ((String)this.value).substring(1).toLowerCase()};
    }

    public String getTranslationKey() {
        return "card_scale_type";
    }
}

