/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.jewel;

import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.item.tool.JewelItem;
import java.util.Locale;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class JewelRarityAttribute
extends StringAttribute {
    public JewelRarityAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof JewelItem)) {
            return null;
        }
        VaultGearRarity rarity = VaultGearData.read((ItemStack)itemStack).getRarity();
        return switch (rarity) {
            case VaultGearRarity.COMMON -> "Chipped";
            case VaultGearRarity.RARE -> "Flawed";
            case VaultGearRarity.EPIC -> "Flawless";
            case VaultGearRarity.OMEGA -> "Perfect";
            default -> StringUtils.capitalize((String)rarity.toString().toLowerCase(Locale.ROOT));
        };
    }

    public String getTranslationKey() {
        return "jewel_rarity";
    }

    @Override
    public String getLegacyKey() {
        return "jewelRarity";
    }
}

