/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.other;

import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.BossRuneItem;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemTypeAttribute
extends StringAttribute {
    public ItemTypeAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof CharmItem) {
            return "Charm";
        }
        if (item instanceof TrinketItem) {
            return "Trinket";
        }
        if (item instanceof JewelItem) {
            return "Jewel";
        }
        if (item instanceof InscriptionItem) {
            return "Inscription";
        }
        if (item instanceof ToolItem) {
            return "Vault Tool";
        }
        if (item instanceof VaultGearItem) {
            return "Gear Piece";
        }
        if (item instanceof InfusedCatalystItem) {
            return "Catalyst";
        }
        if (ItemTypeAttribute.isTreasureDoor(itemStack)) {
            return "Treasure Key";
        }
        if (item instanceof BossRuneItem) {
            return "Boss Rune";
        }
        return null;
    }

    public static boolean isTreasureDoor(ItemStack itemStack) {
        for (TreasureDoorBlock.Type doorType : TreasureDoorBlock.Type.values()) {
            if (itemStack.m_41720_() != doorType.getKey()) continue;
            return true;
        }
        return false;
    }

    public String getTranslationKey() {
        return "item_type";
    }

    @Override
    public String getLegacyKey() {
        return "itemType";
    }
}

