/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.rune;

import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.BossRuneItem;
import iskallia.vault.item.tool.JewelItem;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.joseph.vaultfilters.attributes.gear.IsUnidentifiedAttribute;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class BossRuneGearRarityAttribute
extends StringAttribute {
    public BossRuneGearRarityAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof BossRuneItem)) {
            return null;
        }
        List list = BossRuneItem.getItems((ItemStack)itemStack);
        if (list.isEmpty()) {
            return null;
        }
        ItemStack reward = (ItemStack)list.get(0);
        if (reward.m_41720_() instanceof JewelItem || !(reward.m_41720_() instanceof VaultGearItem)) {
            return null;
        }
        if (Boolean.TRUE.equals(IsUnidentifiedAttribute.isUnidentified(reward))) {
            int rollLength;
            Optional roll = AttributeGearData.read((ItemStack)reward).getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE);
            if (roll.isEmpty()) {
                return null;
            }
            String rollType = (String)roll.get();
            return rollType.charAt((rollLength = rollType.length()) - 1) == '+' ? rollType.substring(0, rollLength - 1) : rollType;
        }
        VaultGearData data = VaultGearData.read((ItemStack)reward);
        return StringUtils.capitalize((String)data.getRarity().toString().toLowerCase(Locale.ROOT));
    }

    public String getTranslationKey() {
        return "boss_rune_gear_rarity";
    }
}

