/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.mixin.compat.ae2.mixin;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.parts.automation.HandlerStrategy;
import appeng.parts.automation.StorageExportStrategy;
import appeng.util.BlockApiCache;
import com.simibubi.create.content.logistics.filter.FilterItem;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.joseph.vaultfilters.VFTests;
import net.joseph.vaultfilters.configs.VFServerConfig;
import net.minecraft.core.Direction;
import org.lwjgl.system.CallbackI;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={StorageExportStrategy.class}, remap=false)
public class MixinStorageExportStrategy<C> {
    @Shadow
    @Final
    private HandlerStrategy<C, CallbackI.S> handlerStrategy;
    @Shadow
    @Final
    private BlockApiCache<C> apiCache;
    @Shadow
    @Final
    private Direction fromSide;

    @Overwrite
    public long transfer(StackTransferContext context, AEKey what, long amount, Actionable mode) {
        long extracted;
        long wasInserted;
        if (!this.handlerStrategy.isSupported(what)) {
            return 0L;
        }
        Object adjacentStorage = this.apiCache.find(this.fromSide);
        if (adjacentStorage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (((Boolean)VFServerConfig.AE2_COMPAT.get()).booleanValue() && itemKey.getItem() instanceof FilterItem) {
                for (Object2LongMap.Entry key : inv.getInventory().getAvailableStacks()) {
                    AEItemKey itemKey2;
                    AEKey aek = (AEKey)key.getKey();
                    if (!(aek instanceof AEItemKey) || !VFTests.checkFilter(itemKey2 = (AEItemKey)aek, (Object)itemKey, true, null)) continue;
                    what = aek;
                    break;
                }
            }
        }
        if ((wasInserted = this.handlerStrategy.insert(adjacentStorage, what, extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE), Actionable.SIMULATE)) > 0L) {
            if (mode == Actionable.MODULATE && (wasInserted = this.handlerStrategy.insert(adjacentStorage, what, extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)wasInserted, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE), Actionable.MODULATE)) < extracted) {
                long leftover = extracted - wasInserted;
                if ((leftover -= inv.getInventory().insert(what, leftover, Actionable.MODULATE, context.getActionSource())) > 0L) {
                    // empty if block
                }
            }
            return wasInserted;
        }
        return 0L;
    }
}

