/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.mixin.compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterScreenPacket;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.joseph.vaultfilters.mixin.compat.create.AttributeFilterMenuAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AttributeFilterScreen.class}, remap=false)
public abstract class MixinAttributeFilterScreen
extends AbstractFilterScreen<AttributeFilterMenu> {
    @Shadow
    private List<ItemAttribute> attributesOfItem = new ArrayList<ItemAttribute>();
    @Shadow
    private List<Component> selectedAttributes;
    @Shadow
    private Component selectedT;
    @Unique
    private int vault_Filters$selectedAttrIndex = 0;
    @Unique
    private int vault_Filters$deletionLastTick = 0;
    @Unique
    private int vault_Filters$deletionProgressTick = 0;
    @Unique
    private static final Component vault_Filters$delTooltipLine = Components.literal((String)"Hold [").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC).m_7220_((Component)Components.literal((String)"DEL").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Components.literal((String)"] to remove attribute"));

    protected MixinAttributeFilterScreen(AttributeFilterMenu menu, Inventory inv, Component title, AllGuiTextures background) {
        super((AbstractFilterMenu)menu, inv, title, background);
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Ljava/util/List;stream()Ljava/util/stream/Stream;", shift=At.Shift.BEFORE)}, method={"referenceItemChanged"})
    public void addAttributesFromFilter(ItemStack stack, CallbackInfo ci) {
        if (stack.m_150930_((Item)AllItems.ATTRIBUTE_FILTER.get())) {
            ListTag attributes;
            boolean defaults = !stack.m_41782_();
            ListTag listTag = attributes = defaults ? new ListTag() : stack.m_41783_().m_128437_("MatchedAttributes", 10);
            if (attributes.isEmpty()) {
                return;
            }
            for (Tag inbt : attributes) {
                CompoundTag compound = (CompoundTag)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT((CompoundTag)compound);
                if (attribute == null) continue;
                this.attributesOfItem.add(attribute);
            }
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        boolean res = super.m_6050_(pMouseX, pMouseY, pDelta);
        if (this.f_97734_ != null && this.f_97734_.f_40219_ == 37) {
            int idx = this.vault_Filters$selectedAttrIndex;
            if (pDelta < 0.0 && idx + 1 < this.selectedAttributes.size() - 2) {
                this.vault_Filters$selectedAttrIndex = idx + 1;
                Component oldAt = this.selectedAttributes.get(idx + 1);
                this.selectedAttributes.set(idx + 1, (Component)Components.literal((String)oldAt.getString()).m_130940_(ChatFormatting.GRAY));
                Component newAt = this.selectedAttributes.get(idx + 2);
                this.selectedAttributes.set(idx + 2, (Component)Components.literal((String)newAt.getString()).m_130940_(ChatFormatting.WHITE));
                this.vault_Filters$deletionProgressTick = 0;
            } else if (pDelta > 0.0 && idx > 0) {
                this.vault_Filters$selectedAttrIndex = idx - 1;
                if (this.selectedAttributes.size() > idx + 1) {
                    Component oldAt = this.selectedAttributes.get(idx + 1);
                    this.selectedAttributes.set(idx + 1, (Component)Components.literal((String)oldAt.getString()).m_130940_(ChatFormatting.GRAY));
                }
                Component newAt = this.selectedAttributes.get(idx);
                this.selectedAttributes.set(idx, (Component)Components.literal((String)newAt.getString()).m_130940_(ChatFormatting.WHITE));
                this.vault_Filters$deletionProgressTick = 0;
            }
        }
        return res;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")}, remap=true)
    private void addDelTooltipLine(CallbackInfo ci) {
        if (this.selectedAttributes.size() > 1) {
            this.selectedAttributes.add(vault_Filters$delTooltipLine);
        }
    }

    @Inject(method={"handleAddedAttibute"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private void rmDelTooltipLine(boolean inverted, CallbackInfoReturnable<Boolean> cir) {
        this.selectedAttributes.remove(vault_Filters$delTooltipLine);
    }

    @Inject(method={"handleAddedAttibute"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void addDelTooltipLine(boolean inverted, CallbackInfoReturnable<Boolean> cir) {
        this.selectedAttributes.add(vault_Filters$delTooltipLine);
    }

    @WrapOperation(method={"renderForeground"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I")})
    private int renderForeground(List<Component> instance, Operation<Integer> original) {
        if (!instance.isEmpty() && instance.get(instance.size() - 1) == vault_Filters$delTooltipLine) {
            return instance.size() - 1;
        }
        return (Integer)original.call(new Object[]{instance});
    }

    @Inject(method={"containerTick"}, at={@At(value="TAIL")}, remap=true)
    private void attributeDeletionTick(CallbackInfo ci) {
        int idx;
        if (this.vault_Filters$pressDel()) {
            idx = this.vault_Filters$selectedAttrIndex;
            List<Pair<ItemAttribute, Boolean>> selectedAttrs = ((AttributeFilterMenuAccessor)this.f_97732_).getSelectedAttributes();
            if (idx >= 0 && idx < selectedAttrs.size()) {
                Pair<ItemAttribute, Boolean> selectedAttr = selectedAttrs.get(idx);
                this.vault_Filters$removeAttr((ItemAttribute)selectedAttr.getFirst(), (Boolean)selectedAttr.getSecond());
                this.vault_Filters$selectedAttrIndex = Math.max(0, idx - 1);
                return;
            }
        }
        if ((idx = this.vault_Filters$selectedAttrIndex) >= 0 && idx + 1 < this.selectedAttributes.size()) {
            float progress = (float)Math.min(Math.max(0, this.vault_Filters$deletionProgressTick), 20) / 20.0f;
            Component selected = this.selectedAttributes.get(idx + 1);
            String text = selected.getString();
            int redChars = (int)((float)text.length() * progress);
            MutableComponent redPart = Components.literal((String)text.substring(0, redChars)).m_130940_(ChatFormatting.RED);
            MutableComponent whitePart = Components.literal((String)text.substring(redChars)).m_130940_(ChatFormatting.WHITE);
            this.selectedAttributes.set(idx + 1, (Component)Components.literal((String)"").m_7220_((Component)redPart).m_7220_((Component)whitePart));
        }
    }

    @Unique
    private boolean vault_Filters$pressDel() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (pl == null) {
            return false;
        }
        int tc = pl.f_19797_;
        if (tc < this.vault_Filters$deletionLastTick || this.vault_Filters$deletionProgressTick < 0) {
            this.vault_Filters$deletionProgressTick = 0;
        }
        if (tc != this.vault_Filters$deletionLastTick) {
            this.vault_Filters$deletionProgressTick = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)261) ? ++this.vault_Filters$deletionProgressTick : --this.vault_Filters$deletionProgressTick;
        }
        this.vault_Filters$deletionLastTick = tc;
        if (this.vault_Filters$deletionProgressTick > 20) {
            this.vault_Filters$deletionProgressTick = 0;
            return true;
        }
        return false;
    }

    @Unique
    private void vault_Filters$addAttr(ItemAttribute itemAttribute, boolean inverted) {
        CompoundTag tag = new CompoundTag();
        itemAttribute.serializeNBT(tag);
        AllPackets.getChannel().sendToServer((Object)new FilterScreenPacket(inverted ? FilterScreenPacket.Option.ADD_INVERTED_TAG : FilterScreenPacket.Option.ADD_TAG, tag));
        ((AttributeFilterMenu)this.f_97732_).appendSelectedAttribute(itemAttribute, inverted);
        if (((AttributeFilterMenuAccessor)this.f_97732_).getSelectedAttributes().size() == 1) {
            this.selectedAttributes.set(0, (Component)this.selectedT.m_6879_().m_130940_(ChatFormatting.YELLOW));
        }
        this.selectedAttributes.remove(vault_Filters$delTooltipLine);
        this.selectedAttributes.add((Component)Components.literal((String)"- ").m_7220_((Component)itemAttribute.format(inverted)).m_130940_(ChatFormatting.GRAY));
        this.selectedAttributes.add(vault_Filters$delTooltipLine);
    }

    @Unique
    private void vault_Filters$removeAttr(ItemAttribute itemAttribute, boolean inverted) {
        Pair toRemove = Pair.of((Object)itemAttribute, (Object)inverted);
        ArrayList<Pair<ItemAttribute, Boolean>> currentAttributes = new ArrayList<Pair<ItemAttribute, Boolean>>(((AttributeFilterMenuAccessor)this.f_97732_).getSelectedAttributes());
        if (currentAttributes.remove(toRemove)) {
            ((AttributeFilterMenu)this.f_97732_).clearContents();
            this.contentsCleared();
            ((AttributeFilterMenu)this.f_97732_).sendClearPacket();
            for (Pair<ItemAttribute, Boolean> pair : currentAttributes) {
                this.vault_Filters$addAttr((ItemAttribute)pair.getFirst(), (Boolean)pair.getSecond());
            }
        }
    }
}

