/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.mixin.other;

import iskallia.vault.VaultMod;
import iskallia.vault.block.item.VaultOreBlockItem;
import iskallia.vault.config.LootInfoConfig;
import iskallia.vault.core.world.loot.LootTableInfo;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.ItemVaultFruit;
import iskallia.vault.item.ItemVaultKey;
import iskallia.vault.item.VaultXPFoodItem;
import iskallia.vault.item.modification.GearModificationItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.joseph.vaultfilters.VaultFilters;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public class MixinTagLoader {
    @Shadow
    @Final
    private String f_13449_;

    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void afterBuild(Map<ResourceLocation, Tag.Builder> pBuilders, CallbackInfoReturnable<Map<ResourceLocation, Tag<?>>> cir) {
        if ("tags/items".equals(this.f_13449_)) {
            Set<ResourceLocation> wooden_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"wooden_chest")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "wooden_chest_loot", wooden_items);
            Set<ResourceLocation> ornate_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"ornate_chest")));
            ornate_items.addAll(MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"ornate_strongbox"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "ornate_chest_loot", ornate_items);
            Set<ResourceLocation> living_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"living_chest")));
            living_items.addAll(MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"living_strongbox"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "living_chest_loot", living_items);
            Set<ResourceLocation> gilded_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"gilded_chest")));
            gilded_items.addAll(MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"gilded_strongbox"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "gilded_chest_loot", gilded_items);
            Set<ResourceLocation> all_chest_items = Stream.of(wooden_items, ornate_items, living_items, gilded_items).flatMap(Collection::stream).collect(Collectors.toSet());
            MixinTagLoader.vaultFilters$createTag(pBuilders, "all_chest_loot", all_chest_items);
            Set<ResourceLocation> treasure_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"treasure_chest")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "treasure_chest_loot", treasure_items);
            Set<ResourceLocation> treasure_sand_treasure = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"treasure_sand")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "treasure_sand_treasure", treasure_sand_treasure);
            Set<ResourceLocation> treasure_sand_digsite = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getResourceLocationsFromStrings(new HashSet<String>(Arrays.asList("digsite_sand_lvl0"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "treasure_sand_digsite", treasure_sand_digsite);
            Set<ResourceLocation> flesh_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"flesh_chest")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "flesh_chest_loot", flesh_items);
            Set<ResourceLocation> enigma_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"enigma_chest")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "enigma_chest_loot", enigma_items);
            Set<ResourceLocation> hardened_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"hardened_chest")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "hardened_chest_loot", hardened_items);
            Set<ResourceLocation> raw_chest_items = Stream.of(hardened_items, enigma_items, flesh_items).flatMap(Collection::stream).collect(Collectors.toSet());
            MixinTagLoader.vaultFilters$createTag(pBuilders, "all_skyvault_loot", raw_chest_items);
            Set<ResourceLocation> coin_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"coin_pile")));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "coin_pile_loot", coin_items);
            Set<ResourceLocation> elixir_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"completion_crate_elixir")));
            Set<ResourceLocation> guardian_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"completion_crate_guardian")));
            Set<ResourceLocation> brazier_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"completion_crate_brazier")));
            Set<ResourceLocation> scavenger_crate_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"completion_crate_scavenger")));
            Set<ResourceLocation> paradox_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"completion_crate_paradox")));
            Set<ResourceLocation> bingo_items = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"completion_crate_bingo")));
            bingo_items.addAll(MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getTablesFromInfo(VaultMod.id((String)"full_bingo"))));
            Set<ResourceLocation> crate_loot = Stream.of(elixir_items, guardian_items, brazier_items, scavenger_crate_items, paradox_items, bingo_items).flatMap(Collection::stream).collect(Collectors.toSet());
            MixinTagLoader.vaultFilters$createTag(pBuilders, "completion_crates_loot", crate_loot);
            Set<ResourceLocation> champion_loot = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getResourceLocationsFromStrings(new HashSet<String>(Arrays.asList("champion_loot_lvl0", "champion_loot_lvl20", "champion_loot_lvl50"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "champion_loot", champion_loot);
            Set<ResourceLocation> rune_loot = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getResourceLocationsFromStrings(new HashSet<String>(Arrays.asList("rune_loot_0", "rune_loot_50"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "rune_loot", rune_loot);
            Set<ResourceLocation> brazier_pillage_loot = MixinTagLoader.vaultFilters$getItemsFromTables(MixinTagLoader.vaultFilters$getResourceLocationsFromStrings(new HashSet<String>(Arrays.asList("brazier_lvl0", "brazier_lvl20", "brazier_lvl50"))));
            MixinTagLoader.vaultFilters$createTag(pBuilders, "brazier_pillaging", brazier_pillage_loot);
            Optional pool = ModConfigs.VAULT_ALTAR_INGREDIENTS.LEVELS.getForLevel(100);
            if (pool.isEmpty()) {
                VaultFilters.LOGGER.info("couldn't get ingredients");
            } else {
                Map map = (Map)pool.get();
                Tag.Builder all = pBuilders.computeIfAbsent(VaultMod.id((String)"vault_altar_all"), id -> Tag.Builder.m_13304_());
                map.forEach((name, pool2) -> {
                    Tag.Builder category = pBuilders.computeIfAbsent(VaultMod.id((String)("vault_altar_" + name)), id -> Tag.Builder.m_13304_());
                    pool2.forEach((entry, num) -> entry.getItems().forEach(itemStack -> {
                        ResourceLocation rl = itemStack.m_41720_().getRegistryName();
                        if (Registry.f_122827_.m_6612_(rl).isPresent()) {
                            all.m_13327_(rl, "Vault Filters dynamic tags");
                            category.m_13327_(rl, "Vault Filters dynamic tags");
                        }
                    }));
                });
            }
            Tag.Builder treasureKey = pBuilders.computeIfAbsent(VaultMod.id((String)"keys"), id -> Tag.Builder.m_13304_());
            Tag.Builder fruit = pBuilders.computeIfAbsent(VaultMod.id((String)"fruits"), id -> Tag.Builder.m_13304_());
            Tag.Builder focuses = pBuilders.computeIfAbsent(VaultMod.id((String)"focuses"), id -> Tag.Builder.m_13304_());
            Tag.Builder burgers = pBuilders.computeIfAbsent(VaultMod.id((String)"burgers"), id -> Tag.Builder.m_13304_());
            Tag.Builder ores = pBuilders.computeIfAbsent(VaultMod.id((String)"vault_ores"), id -> Tag.Builder.m_13304_());
            Registry.f_122827_.m_6566_().stream().map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_6612_(arg_0)).flatMap(Optional::stream).forEach(item -> {
                ResourceLocation rl = item.getRegistryName();
                if (rl == null) {
                    return;
                }
                if (item instanceof ItemVaultKey) {
                    treasureKey.m_13327_(rl, "Vault Filters dynamic tags");
                }
                if (item instanceof ItemVaultFruit) {
                    fruit.m_13327_(rl, "Vault Filters dynamic tags");
                }
                if (item instanceof GearModificationItem) {
                    focuses.m_13327_(rl, "Vault Filters dynamic tags");
                }
                if (item instanceof VaultXPFoodItem) {
                    burgers.m_13327_(rl, "Vault Filters dynamic tags");
                }
                if (item instanceof VaultOreBlockItem) {
                    ores.m_13327_(rl, "Vault Filters dynamic tags");
                }
            });
        }
    }

    @Unique
    private static Set<ResourceLocation> vaultFilters$getResourceLocationsFromStrings(Set<String> strings) {
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        strings.forEach(string -> locations.add(VaultMod.id((String)string)));
        return locations;
    }

    @Unique
    private static Set<ResourceLocation> vaultFilters$getTablesFromInfo(ResourceLocation location) {
        LootInfoConfig.LootInfo lootInfo = (LootInfoConfig.LootInfo)ModConfigs.LOOT_INFO_CONFIG.getLootInfoMap().get(location);
        return lootInfo != null ? lootInfo.getLootTableKeys() : Collections.emptySet();
    }

    @Unique
    private static Set<ResourceLocation> vaultFilters$getItemsFromTables(Set<ResourceLocation> tables) {
        HashSet<ResourceLocation> allItems = new HashSet<ResourceLocation>();
        tables.forEach(table -> allItems.addAll(MixinTagLoader.vaultFilters$getItemsFromTable(table)));
        return allItems;
    }

    @Unique
    private static Set<ResourceLocation> vaultFilters$getItemsFromTable(ResourceLocation table) {
        return LootTableInfo.getItemsForLootTableKey((ResourceLocation)table);
    }

    @Unique
    private static void vaultFilters$createTag(Map<ResourceLocation, Tag.Builder> pBuilders, String tag, Set<ResourceLocation> items) {
        Tag.Builder lootTag = pBuilders.computeIfAbsent(VaultMod.id((String)tag), id -> Tag.Builder.m_13304_());
        items.forEach(item -> {
            if (Registry.f_122827_.m_6612_(item).isPresent()) {
                lootTag.m_13327_(item, "Vault Filters dynamic tags");
            }
        });
    }
}

