/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism.custom;

import dev.latvian.kubejs.mekanism.MekanismKubeJSPlugin;
import dev.latvian.kubejs.mekanism.custom.KubeJSChemicalBuilder;
import dev.latvian.kubejs.mekanism.util.CachingGasProvider;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import java.util.function.Supplier;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasBuilder;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IGasProvider;
import net.minecraft.resources.ResourceLocation;

public class KubeJSGasBuilder
extends KubeJSChemicalBuilder<Gas, GasBuilder, KubeJSGasBuilder> {
    private ResourceLocation texture = null;

    public KubeJSGasBuilder(ResourceLocation id) {
        super(id);
    }

    @Override
    protected Supplier<GasBuilder> bindBuilder() {
        return () -> this.texture == null ? GasBuilder.builder() : GasBuilder.builder((ResourceLocation)this.texture);
    }

    public KubeJSGasBuilder texture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public KubeJSGasBuilder radioactivity(double radioactivity) {
        return (KubeJSGasBuilder)((Object)this.with((ChemicalAttribute)new GasAttributes.Radiation(radioactivity)));
    }

    public KubeJSGasBuilder coolant(boolean heated, ResourceLocation counterpart, double thermalEnthalpy, double conductivity) {
        if (heated) {
            return (KubeJSGasBuilder)((Object)this.with((ChemicalAttribute)new GasAttributes.HeatedCoolant((IGasProvider)new CachingGasProvider(counterpart), thermalEnthalpy, conductivity)));
        }
        return (KubeJSGasBuilder)((Object)this.with((ChemicalAttribute)new GasAttributes.CooledCoolant((IGasProvider)new CachingGasProvider(counterpart), thermalEnthalpy, conductivity)));
    }

    public KubeJSGasBuilder fuel(int burnTicks, double energy) {
        FloatingLong density = FloatingLong.createConst((double)energy);
        if (burnTicks <= 0) {
            throw new IllegalArgumentException("Fuel attributes must burn for at least one tick! Burn Ticks: " + burnTicks);
        }
        if (density.isZero()) {
            throw new IllegalArgumentException("Fuel attributes must have an energy density greater than zero!");
        }
        return (KubeJSGasBuilder)((Object)this.with((ChemicalAttribute)new GasAttributes.Fuel(() -> burnTicks, () -> density)));
    }

    public RegistryObjectBuilderTypes<Gas> getRegistryType() {
        return MekanismKubeJSPlugin.GAS;
    }

    public Gas createObject() {
        if (this.barColor == null) {
            return new Gas((GasBuilder)this.builder());
        }
        final int color = this.barColor;
        return new Gas((GasBuilder)this.builder()){

            public int getColorRepresentation() {
                return color;
            }
        };
    }
}

