/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal;

import agency.highlysuspect.incorporeal.IncConfig;
import agency.highlysuspect.incorporeal.IncItems;
import agency.highlysuspect.incorporeal.block.entity.EnderSoulCoreBlockEntity;
import agency.highlysuspect.incorporeal.block.entity.RedStringLiarBlockEntity;
import agency.highlysuspect.incorporeal.computer.types.DataLenses;
import agency.highlysuspect.incorporeal.computer.types.DataReducers;
import agency.highlysuspect.incorporeal.computer.types.DataTypes;
import agency.highlysuspect.incorporeal.corporea.AndingCorporeaRequestMatcher;
import agency.highlysuspect.incorporeal.corporea.EmptyCorporeaRequestMatcher;
import agency.highlysuspect.incorporeal.corporea.InvertedCorporeaRequestMatcher;
import agency.highlysuspect.incorporeal.item.BoundEnderPearlItem;
import agency.highlysuspect.incorporeal.platform.IncBootstrapper;
import agency.highlysuspect.incorporeal.platform.IncXplat;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;

public class Inc {
    public static final String MODID = "incorporeal";
    public static final Logger LOGGER = LogManager.getLogger((String)"incorporeal");
    public static Inc INSTANCE = new Inc(IncXplat.INSTANCE.createBootstrapper());
    public final IncConfig config;
    private final IncBootstrapper bootstrapper;
    private boolean selfInit = false;
    private boolean botaniaInit = false;
    private boolean bothInit = false;

    private Inc(IncBootstrapper bootstrapper) {
        this.bootstrapper = bootstrapper;
        this.config = new IncConfig(bootstrapper.createConfigBuilder(MODID));
    }

    public void onInitialize() {
        this.bootstrapper.registerBlocks();
        this.bootstrapper.registerBlockEntityTypes();
        this.bootstrapper.registerItems();
        this.bootstrapper.registerEntityTypes();
        this.bootstrapper.registerEntityAttributes();
        this.bootstrapper.registerSoundEvents();
        this.bootstrapper.registerServerToClientNetworkChannelSender();
        this.bootstrapper.registerCapabilities();
        this.bootstrapper.registerCommands();
        DataTypes.registerBuiltinTypes();
        DataReducers.registerBuiltinReducers();
        DataLenses.registerBuiltinLenses();
        this.selfInit = true;
        this.bootstrapper.endSelfInit();
        this.tryAfterBotaniaInitialization();
    }

    public void markBotaniaAsDoneInitializing() {
        this.botaniaInit = true;
        this.tryAfterBotaniaInitialization();
    }

    private void tryAfterBotaniaInitialization() {
        if (!this.bothInit && this.selfInit && this.botaniaInit) {
            this.bothInit = true;
            this.bootstrapper.registerCorporeaIndexCallback();
            this.bootstrapper.registerRedstoneRootPlaceEvent();
            CorporeaHelper.instance().registerRequestMatcher(Inc.id("empty"), EmptyCorporeaRequestMatcher.class, __ -> EmptyCorporeaRequestMatcher.INSTANCE);
            CorporeaHelper.instance().registerRequestMatcher(Inc.id("not"), InvertedCorporeaRequestMatcher.class, InvertedCorporeaRequestMatcher::readFromNBT);
            CorporeaHelper.instance().registerRequestMatcher(Inc.id("not-fallback"), InvertedCorporeaRequestMatcher.Fallback.class, __ -> InvertedCorporeaRequestMatcher.Fallback.INSTANCE);
            CorporeaHelper.instance().registerRequestMatcher(Inc.id("and"), AndingCorporeaRequestMatcher.class, AndingCorporeaRequestMatcher::readFromNbt);
            CorporeaNodeDetectors.register((ICorporeaNodeDetector)new RedStringLiarBlockEntity.NodeDetector());
            CorporeaNodeDetectors.register((ICorporeaNodeDetector)new EnderSoulCoreBlockEntity.NodeDetector());
        }
    }

    public void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)IncItems.BOUND_ENDER_PEARL, (DispenseItemBehavior)new BoundEnderPearlItem.DispenseBehavior(IncItems.BOUND_ENDER_PEARL));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static ResourceLocation botaniaId(String path) {
        return new ResourceLocation("botania", path);
    }

    public static <T> T choose(List<T> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public static float rangeRemap(float value, float low1, float high1, float low2, float high2) {
        float x = (value - low1) / (high1 - low1);
        return x * (high2 - low2) + low2;
    }

    public static float sinDegrees(float in) {
        return Mth.m_14031_((float)(in % 360.0f * ((float)Math.PI / 180)));
    }

    public static float cosDegrees(float in) {
        return Mth.m_14089_((float)(in % 360.0f * ((float)Math.PI / 180)));
    }

    public static <T> Map<DyeColor, T> sixteenColors(Function<DyeColor, T> maker) {
        EnumMap<DyeColor, T> map = new EnumMap<DyeColor, T>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            map.put(color, maker.apply(color));
        }
        return map;
    }
}

