/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block;

import agency.highlysuspect.incorporeal.util.CompressedTaterUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.decor.BlockTinyPotato;
import vazkii.botania.common.block.tile.TileTinyPotato;

public class CompressedTinyPotatoBlock
extends BlockTinyPotato {
    public final int compressionLevel;
    public final VoxelShape shape;
    public static final int TATERS_PER_COMPRESSION_LEVEL = 9;

    public CompressedTinyPotatoBlock(int compressionLevel, BlockBehaviour.Properties builder) {
        super(builder);
        this.compressionLevel = compressionLevel;
        float radius = CompressedTaterUtil.taterRadius(compressionLevel);
        float height = radius * 3.0f;
        this.shape = Shapes.m_83048_((double)(0.5 - (double)radius), (double)0.0, (double)(0.5 - (double)radius), (double)(0.5 + (double)radius), (double)height, (double)(0.5 + (double)radius));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag piss) {
        tooltip.add((Component)CompressedTaterUtil.formatCount(this.compressionLevel, 9));
        super.m_5871_(stack, level, tooltip, piss);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.shape;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileTinyPotato) {
            TileTinyPotato tater = (TileTinyPotato)tile;
            tater.interact(player, hand, player.m_21120_(hand), hit.m_82434_());
            if (!world.f_46443_) {
                AABB box = this.shape.m_83215_();
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pos.m_123341_() + box.f_82288_ + Math.random() * (box.f_82291_ - box.f_82288_), (double)pos.m_123342_() + box.f_82292_, (double)pos.m_123343_() + box.f_82290_ + Math.random() * (box.f_82293_ - box.f_82290_), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

